#include <bits/stdc++.h>
#include <cassert>
// called as ./output_validator test.in test.ans < test.out
using namespace std;
const int AC = 42, WA = 43;
long double eps = 1e-6;
int main(int argc, const char *args[]) {
	assert(argc == 3);
	auto in   = ifstream(args[1]);
	auto ans  = ifstream(args[2]);
	auto &out = cin;

	// Answer is impossible
	if(ans.peek() == 'i') {
		string s;
		ans >> s;
		assert(s == "impossible");
		out >> s;
		if(s != "impossible") {
			cout << "The answer is Impossible, but the output starts with: " << s << "\n";
			return WA;
		}
		// we don't have to worry about trailing input
		// due to grammar check
		return AC;
	}

	// here we read the four numbers
	int x, y, x2, y2; // player at (x,y) passes to (x2,y2)
	long double answer_distance, answer_angle;
	out >> x2 >> y2 >> answer_distance >> answer_angle;

	// first verify that the given player is part of the input
	int n;
	long double a, b;
	in >> n >> a >> b >> x >> y;
	long double xin, yin;
	while(n-- && in >> xin >> yin)
		if(xin == x2 && yin == y2) goto found;
	cout << "Position " << x2 << ' ' << y2
	     << " was submitted, but no player at that location was found!\n";
	return WA;
found:
	// now check that the actual distance is within range
	long double dist = sqrt((x2 - x) * (x2 - x) + (y2 - y) * (y2 - y));
	if(dist < a - eps || dist > b + eps) {
		cout << "The actual distance is " << dist << ", "
		     << "while it should be between " << a << " and " << b << endl;
		return WA;
	}

	// check the given distance
	long double tolerance = max(eps, dist * eps);
	if(abs(answer_distance - dist) > tolerance) {
		cout << "The actual distance is " << dist
		     << ", which differs more than 10^-6 from the submitted distance, " << answer_distance
		     << endl;
		return WA;
	}

	// check the angle range
	long double pi = acos(-1.0l);
	if(answer_angle < -pi * (1 + eps) || answer_angle > pi * (1 + eps)) {
		cout << "The angle should be in [-pi,pi); the submitted angle " << answer_angle
		     << " is not.\n";
		return WA;
	}
	// calculate the angle; this is in [-pi,pi)
	long double angle = atan2((long double)(y2 - y), (long double)(x2 - x));

	// this is to accept 2pi-eps as being close to 0
	if(angle < 0 && answer_angle > 0) answer_angle -= 2 * pi;
	if(angle > 0 && answer_angle < 0) answer_angle += 2 * pi;

	// check angle value
	tolerance = max(eps, angle * eps);
	if(abs(answer_angle - angle) > tolerance) {
		cout << "The angle should be " << angle << ". The submitted angle " << answer_angle
		     << " differs by more than 10^-6.\n";
		return WA;
	}

	return AC;
}
