#include "validation.h"

int main(int argc, char** argv) {
	InputValidator v(argc, argv);

	std::string s = v.read_string("s", 1, 1000, "1234567890");
	v.check(!s.empty(), "empty string is not allowed");
	v.check(s.size() <= 1000, "n < 10^1000 failed");

	for (char ch : s) {
		v.check('0' <= ch && ch <= '9', "digit expected, ", ch, " given");
	}

	v.check(s[0] != '0' || s.size() == 1, "no leading zero expected");

	v.newline();
	return 0;
}
