#!/usr/bin/env python3

import sys


def before(a, b):
    if a == "Q":
        return b >= "U"
    return a <= b


def solve(lines, comparator=before):
    front = lines[0]
    sides: list[set[str]] = [set() for _ in range(16)]
    for line in lines[1:5]:
        for i, l in enumerate(line):
            sides[i].add(l)
    back = lines[-1]

    best = [(0, front[0]), (2, back[0])] + [(1, letter) for letter in sides[0] if letter != front[0]]
    for i in range(1, 16):
        new_best = []
        for letter, delta in [(front[i], 0)] + [(side, 1) for side in sides[i]] + [(back[i], 2)]:
            for turns, prefix in best:
                if comparator(prefix[-1], letter):
                    new_best.append((turns + delta, prefix + letter))
                    if len(new_best) > 100000:  # Else, it's too slow
                        return "impossible"
        best = new_best
    if best:
        return min(best)
    else:
        return "impossible"


def qufy(c):
    if c == "Q":
        return "\small Qu"
    else:
        return c


with open(sys.argv[1]) as infile, sys.stdout as texfile:
    lines = [line.strip() for line in infile.readlines()]
    solution = solve(lines)

    print(
        r"""\documentclass[varwidth]{standalone}
% Make the PDF content reproducible by omitting time-/machine-based metadata: https://tex.stackexchange.com/a/313605
\pdfinfoomitdate=1
\pdftrailerid{}
\pdfsuppressptexinfo=-1
\usepackage{tikz}
\usetikzlibrary{matrix, fit}
\tikzset{every node/.style={font=\sffamily}}
\begin{document}
    """,
        file=texfile,
    )
    for i in range(16):
        print(r"\begin{tikzpicture}", file=texfile)
        print(
            r"\matrix [every node/.style={draw, minimum size=18pt, outer sep=0pt},  column sep=-\pgflinewidth, row sep=-\pgflinewidth] (m) {",
            file=texfile,
        )
        if solution != "impossible":
            turn = min(j for j in range(6) if solution[1][i] == lines[j][i])
            style = {j: ("[fill=blue!10]" if j == turn else "") for j in range(6)}
        else:
            style = {j: "" for j in range(6)}
        print(r"&\node", style[1], "{", qufy(lines[1][i]), r"};\\", file=texfile)
        print(r"\node", style[2], " {", qufy(lines[2][i]), r"};", file=texfile)
        print(r"& \node", style[0], "{", qufy(lines[0][i]), r"};", file=texfile)
        print(r"& \node", style[3], "{", qufy(lines[3][i]), r"};", file=texfile)
        print(r"& \node", style[5], "{", qufy(lines[5][i]), r"};\\", file=texfile)
        print(r"& \node", style[4], "{", qufy(lines[4][i]), r"};\\", file=texfile)
        print(r"};", file=texfile)

        print(r"\end{tikzpicture}", file=texfile)
        if i % 4 == 3:
            print(r"\\", file=texfile)
            print(file=texfile)
    print(r"\end{document}", file=texfile)
