import java.io.*;
import java.util.*;

public class MikeFastScanner {
    static final double q = 50.8;
    static final int w = 211;
    static final long wx = 200000L;

    static final class Model {
        long x, y;
        double r;
        int i;

        boolean isClose(Model m) {
            // Use hypot for numerical stability
            double dx = (double) (x - m.x);
            double dy = (double) (y - m.y);
            double dist = Math.hypot(dx, dy);
            return dist < (r + m.r + q);
        }
    }

    public static void main(String[] args) throws Exception {
        FastScanner sc = new FastScanner(System.in);
        int n = sc.nextInt();
        HashMap<Long, ArrayList<Model>> buckets = new HashMap<>();
        for (int i = 0; i < n; ++i) {
            Model m = new Model();
            m.x = sc.nextLong();
            m.y = sc.nextLong();
            m.r = sc.nextDouble() / 2.0;
            m.i = i;
            long xi = Math.floorDiv(m.x, w);
            long yi = Math.floorDiv(m.y, w);
            long k1 = xi * wx + yi;
            long k2 = (xi + 1) * wx + yi;
            long k3 = xi * wx + (yi + 1);
            long k4 = (xi + 1) * wx + (yi + 1);
            buckets.computeIfAbsent(k1, kk -> new ArrayList<>()).add(m);
            buckets.computeIfAbsent(k2, kk -> new ArrayList<>()).add(m);
            buckets.computeIfAbsent(k3, kk -> new ArrayList<>()).add(m);
            buckets.computeIfAbsent(k4, kk -> new ArrayList<>()).add(m);
        }
        ArrayList<HashSet<Integer>> g = new ArrayList<>(n);
        for (int i = 0; i < n; ++i) g.add(new HashSet<>());
        for (Map.Entry<Long, ArrayList<Model>> e : buckets.entrySet()) {
            ArrayList<Model> b = e.getValue();
            int bc = b.size();
            for (int i = 0; i < bc; ++i) {
                Model mi = b.get(i);
                for (int j = i + 1; j < bc; ++j) {
                    Model mj = b.get(j);
                    if (mi.isClose(mj)) {
                        g.get(mi.i).add(mj.i);
                        g.get(mj.i).add(mi.i);
                    }
                }
            }
        }
        if (n >= 7) {
            for (int i = 0; i < n; ++i) {
                if (g.get(i).size() <= 1) {
                    System.out.println("no");
                    return;
                }
            }
        }
        boolean[] reach = new boolean[n];
        ArrayDeque<Integer> stack = new ArrayDeque<>();
        reach[0] = true;
        stack.push(0);
        int done = 1;
        while (!stack.isEmpty()) {
            int i = stack.pop();
            for (int j : g.get(i))
                if (!reach[j]) {
                    reach[j] = true;
                    stack.push(j);
                    ++done;
                }
        }
        System.out.println(done == n ? "yes" : "no");
    }

    static final class FastScanner {
        private final InputStream in;
        private final byte[] buffer = new byte[1 << 16];
        private int ptr = 0, len = 0;

        FastScanner(InputStream is) {
            in = is;
        }

        private int read() throws IOException {
            if (ptr >= len) {
                len = in.read(buffer);
                ptr = 0;
                if (len <= 0) return -1;
            }
            return buffer[ptr++];
        }

        int nextInt() throws IOException {
            int c, s = 1, x = 0;
            do {
                c = read();
            } while (c <= 32);
            if (c == '-') {
                s = -1;
                c = read();
            }
            while (c > 32) {
                x = x * 10 + (c - '0');
                c = read();
            }
            return x * s;
        }

        long nextLong() throws IOException {
            int c, s = 1;
            long x = 0;
            do {
                c = read();
            } while (c <= 32);
            if (c == '-') {
                s = -1;
                c = read();
            }
            while (c > 32) {
                x = x * 10 + (c - '0');
                c = read();
            }
            return s == 1 ? x : -x;
        }

        double nextDouble() throws IOException {
            return Double.parseDouble(next());
        }

        String next() throws IOException {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = read();
            } while (c <= 32);
            while (c > 32) {
                sb.append((char) c);
                c = read();
            }
            return sb.toString();
        }
    }
}
