import java.io.*;
import java.util.*;

public class MikeScanner {
    static final double q = 50.8;
    static final int w = 211;
    static final long wx = 200000L;

    static final class Model {
        long x, y;
        double r;
        int i;

        boolean isClose(Model m) {
            // Use hypot for numerical stability
            double dx = (double) (x - m.x);
            double dy = (double) (y - m.y);
            double dist = Math.hypot(dx, dy);
            return dist < (r + m.r + q);
        }
    }

    public static void main(String[] args) throws Exception {
        Scanner sc = new Scanner(System.in);
        int n = sc.nextInt();
        HashMap<Long, ArrayList<Model>> buckets = new HashMap<>();
        for (int i = 0; i < n; ++i) {
            Model m = new Model();
            m.x = sc.nextLong();
            m.y = sc.nextLong();
            m.r = sc.nextDouble() / 2.0;
            m.i = i;
            long xi = Math.floorDiv(m.x, w);
            long yi = Math.floorDiv(m.y, w);
            long k1 = xi * wx + yi;
            long k2 = (xi + 1) * wx + yi;
            long k3 = xi * wx + (yi + 1);
            long k4 = (xi + 1) * wx + (yi + 1);
            buckets.computeIfAbsent(k1, kk -> new ArrayList<>()).add(m);
            buckets.computeIfAbsent(k2, kk -> new ArrayList<>()).add(m);
            buckets.computeIfAbsent(k3, kk -> new ArrayList<>()).add(m);
            buckets.computeIfAbsent(k4, kk -> new ArrayList<>()).add(m);
        }
        ArrayList<HashSet<Integer>> g = new ArrayList<>(n);
        for (int i = 0; i < n; ++i) g.add(new HashSet<>());
        for (Map.Entry<Long, ArrayList<Model>> e : buckets.entrySet()) {
            ArrayList<Model> b = e.getValue();
            int bc = b.size();
            for (int i = 0; i < bc; ++i) {
                Model mi = b.get(i);
                for (int j = i + 1; j < bc; ++j) {
                    Model mj = b.get(j);
                    if (mi.isClose(mj)) {
                        g.get(mi.i).add(mj.i);
                        g.get(mj.i).add(mi.i);
                    }
                }
            }
        }
        if (n >= 7) {
            for (int i = 0; i < n; ++i) {
                if (g.get(i).size() <= 1) {
                    System.out.println("no");
                    return;
                }
            }
        }
        boolean[] reach = new boolean[n];
        ArrayDeque<Integer> stack = new ArrayDeque<>();
        reach[0] = true;
        stack.push(0);
        int done = 1;
        while (!stack.isEmpty()) {
            int i = stack.pop();
            for (int j : g.get(i))
                if (!reach[j]) {
                    reach[j] = true;
                    stack.push(j);
                    ++done;
                }
        }
        System.out.println(done == n ? "yes" : "no");
    }
}
