#pragma GCC optimize("O3")
#include <vector>
#include <iostream>
#include <algorithm>
#include <array>
#include <math.h>
#include <numeric>
#include <random>
#include <assert.h>
using namespace std;
const int MXD = ceil(25.4*2 + 160 + 0.00001);
const int MX = 1e8;
double sq(double x) {
    return x*x;
}
template<typename IT, typename K> void radixsort(IT l, IT r, int MX, K key) { // values in [0,MX)
    // one pass of radix sort.
    if(l==r) return;
    vector<int> cnt(MX);
    for(auto i =l;i!=r;++i) cnt[key(*i)]++;
    partial_sum(begin(cnt),end(cnt),cnt.begin());
    vector<typename IT::value_type> buf(r-l);
    auto i = r;
    do {
        i--;
        buf[--cnt[key(*i)]]=*i;
    } while(i!=l);
    move(begin(buf),end(buf),l);
}
struct DSU{
    vector<int> sz,parent;
    int components;
    DSU(int n) {
        sz.assign(n,1);
        components = n;
        parent.resize(n);
        iota(begin(parent),end(parent),0);
    }
    void link(int a, int b) {
        components--;
        if(sz[a]<sz[b]) {
            swap(a,b);
        }
        sz[a]+=sz[b];
        parent[b] = a;
    }
    bool unite(int a, int b) {
        int pa = find(a),pb = find(b);
        if(pa!=pb) link(pa,pb);
        return pa!=pb;
    }
    int find(int a) {
        if(a==parent[a]) return a;
        return parent[a] = find(parent[a]);
    }
};
int main() {
    cin.tie(NULL);
    cin.sync_with_stdio(false);
    int n; cin >> n;
    vector<array<int,5>> cs(n);
    for(auto& [xd,yd, x,y,r] : cs) {
        cin >> x >> y >> r;
        xd=x/MXD,yd=y/MXD;
    }
    auto getc = [&](int i) {
        return array<int,2>{cs[i][0],cs[i][1]};
    };
    radixsort(begin(cs),end(cs), MX/MXD+1, [&](auto& a) {
        return a[1];
    });
    radixsort(begin(cs),end(cs), MX/MXD+1, [&](auto& a) {
        return a[0];
    });
    auto near = [&](int i, int j) {
        auto [xd,yd,x,y,r] = cs[i];
        auto [xd2,yd2,x2,y2,r2] = cs[j];
        return (sq(x-x2) + sq(y-y2) ) < sq(25.4*2 + (r+r2)/2.);
    };


    DSU dsu(n);
    vector<int> deg(n);
    auto addE = [&](int u, int v) {
        deg[u]++;
        deg[v]++;
        dsu.unite(u,v);
    };
    for(auto [dx,dy] : {array<int,2>{0,0},{0,1},{1,-1},{1,0},{1,1}}) {
        int it = 0, jt = 0;
        for(int i=0;i<n;++i) {
            array<int,2> want = getc(i);
            want[0]+=dx,want[1]+=dy;
            while(it!=n and getc(it)<want) {
                ++it;
            }
            if(dx==0 and dy==0) {
                while(it<=i) {
                    ++it;
                }
            }
            while(jt!=n and getc(jt)<=want) {
                ++jt;
            }
            for(auto kt = it;kt!=jt;++kt) {
                if(near(kt,i)) {
                    addE(kt,i);
                }
            }
        }
    }
    if(dsu.components==1 and (n<7 or *min_element(begin(deg),end(deg))>=2)) {
        cout << "yes\n";
    } else cout << "no\n";
    
    
}

