
#include <iostream>
#include <vector>
#include <set>
#include <utility>
#include <queue>

struct model{
    long long x, y, r;
    int i;
    bool reach(const model &m) const {
        long long dx = x-m.x, dy = y-m.y, td = r+m.r;
        return dx*dx + dy*dy <= td*td;
    }
};

int main(){
    int n;
    std::cin >> n;
    auto comp1 = [](const std::pair<model, long long> &m1, const std::pair<model, long long> &m2){
        long long x1 = m1.first.x + m1.second * m1.first.r, x2 = m2.first.x + m2.second * m2.first.r;
        return x1 == x2 ? (m1.first.x == m2.first.x ? m1.first.y > m2.first.y : m1.first.x > m2.first.x) : x1 > x2;
    };
    std::priority_queue<std::pair<model, long long>, std::vector<std::pair<model, long long>>, decltype(comp1)> q(comp1);
    for (int i = 0; i < n; ++i){
        model m = {0, 0, 0, i};
        std::cin >> m.x >> m.y >> m.r;
        m.x *= 10; m.y *= 10; m.r = m.r * 5 + 254;
        q.push({m, 1});
        q.push({m, -1});
    }
    std::vector<std::vector<int>> g(n);
    auto comp2 = [](const model &m1, const model &m2){return m1.y == m2.y ? m1.x < m2.x : m1.y < m2.y;};
    std::set<model, decltype(comp2)> bst(comp2);
    while (!q.empty()){
        const std::pair<model, long long> &mp = q.top();
        const model &m = mp.first;
        auto it = bst.lower_bound(m);
        if (mp.second == -1){
            auto it2 = it;
            while (it != bst.end() && m.reach(*it)){
                g[m.i].push_back(it->i);
                g[it->i].push_back(m.i);
                ++it;
            }
            while (it2 != bst.begin() && m.reach(*(--it2))){
                g[m.i].push_back(it2->i);
                g[it2->i].push_back(m.i);
            }
            bst.insert(m);
        }
        else bst.erase(it);
        q.pop();
    }
    std::vector<bool> leaf(n, true), done(n);
    int leafs = n, dones = 0;
    std::vector<int> todo = {0};
    while (!todo.empty()){
        int i = todo.back();
        todo.pop_back();
        if (done[i]) continue;
        for (int j = 0; j < g[i].size(); ++j){
            todo.push_back(g[i][j]);
            if (j > 0 && g[i][j] != g[i][j-1]){
                leafs -= leaf[i];
                leaf[i] = false;
            }
        }
        done[i] = true;
        ++dones;
    }
    if (dones == n && (n < 7 || leafs == 0)) std::cout << "yes\n";
    else std::cout << "no\n";
    return 0;
}
