#include <iostream>
#include <vector>
#include <cmath>
#include <unordered_set>
#include <unordered_map>
#include <algorithm>

const long long BASE = 1000000007;

int main() {
    int n;
    std::cin >> n;
    
    std::vector<std::vector<long long>> sets(n);
    for (int i = 0; i < n; ++i){
        int k;
        std::cin >> k;
        sets[i].resize(k);
        for (int j = 0; j < k; ++j) std::cin >> sets[i][j];
    }
    
    int L = sqrtl(n);
    std::unordered_map<long long, int> pairs;
    for (int i = 0; i < n; ++i){
        if (sets[i].size() <= L){
            std::sort(sets[i].begin(), sets[i].end());
            for (int j1 = 0; j1 < sets[i].size(); ++j1) for (int j2 = j1+1; j2 < sets[i].size(); ++j2){
                long long x = sets[i][j1] + BASE * sets[i][j2];
                if (pairs.count(x)){
                    std::cout << sets[i][j1] << ' ' << sets[i][j2] << ' ' << pairs[x]+1 << ' ' << i+1 << std::endl;
                    return 0;
                }
                pairs[x] = i;
            }
        }
        else{
            std::unordered_set<long long> xs(sets[i].begin(), sets[i].end());
            for (int j = 0; j < n; ++j) if (i != j){
                std::vector<long long> overlap;
                for (long long x : sets[j]) if (xs.count(x)) overlap.push_back(x);
                if (overlap.size() >= 2){
                    std::cout << overlap[0] << ' ' << overlap[1] << ' ' << j+1 << ' ' << i+1 << std::endl;
                    return 0;
                }
            }
        }
    }
    
    std::cout << "impossible" << std::endl;
    return 0;
}
