#include <algorithm>
#include <array>
#include <bitset>
#include <cassert>
#include <charconv>
#include <cstring>
#include <fstream>
#include <functional>
#include <iomanip>
#include <iostream>
#include <limits>
#include <map>
#include <optional>
#include <random>
#include <set>
#include <stdexcept>
#include <string>
#include <string_view>
#include <type_traits>
#include <unordered_map>
#include <utility>
#include <variant>
#include <vector>
#include <queue>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef pair<ll, ll> ii;
typedef vector<ll> vi;
typedef vector<vi> vvi;
typedef vector<ii> vii;

#define x first
#define y second
#define pb push_back
#define eb emplace_back
#define rep(i,a,b) for(auto i=(a); i<(b); ++i)
#define REP(i,n) rep(i,0,n)
#define all(v) (v).begin(), (v).end()
#define rs resize
#define DBG(x) cerr << __LINE__ << ": " << #x << " = " << (x) << endl

const ld PI = acos(-1.0);
template<class T> using min_queue =
priority_queue<T, vector<T>, greater<T>>;
template<class T> int sz(const T &x) {
    return (int) x.size(); // copy the ampersand(&)!
}

// START OF ACTUAL PROGRAM, START READING HERE
const ll M = 1'000'000;

ll optimal_delta(const vi& F, const vi& T, ll i) {
	ll f0 = F[i], f1 = F[i], t = T[i];
	if (i > 0 && F[i-1] > F[i]) f0 = 2*M-f0;
	if (F[i] > F[i+1]) f1 = 2*M-f1;
	return (f0+t-f1+2*M)%(2*M);
}

ll simulate(const vi& F, const vi& T, const vi& S) {
	ll n = F.size();
	ll res = 0;
	for (ll i = 0; i < n; i++) {
		res += T[i];
	}
	res += F[0];
	for (ll i = 0; i < n-1; i++) {
		res += abs(F[i] - F[i+1]);
	}
	ll e = 0;
	for (ll i = 0; i < n-1; i++) {
		ll be = -1, br = 2*M+1;
		for (ll j = 0; j < 4; j++) {
			ll r = (S[j] - S[e] - optimal_delta(F, T, i) + 6*M)%(2*M);
			if (r < br) {
				be = j; br = r;
			}
		}
		e = be;
		res += br;
	}
	return res;
}

void run() {
	ll n;
	cin >> n;
	vi F(n), T(n);
	for (ll i = 0; i < n; i++) {
		cin >> F[i];
	}
	for (ll i = 0; i < n; i++) {
		cin >> T[i];
	}
	vi S(4, 0);
	ll res = simulate(F, T, S);
	for (ll i1 = 0; i1 < n-1; i1++) {
		for (ll i2 = 0; i2 < n-1; i2++) {
			for (ll i3 = 0; i3 < n-1; i3++) {
				ll j1 = 0;
				S[1] = (S[j1] + optimal_delta(F, T, i1))%(2*M);
				for (ll j2 = 0; j2 < 2; j2++) {
					S[2] = (S[j2] + optimal_delta(F, T, i2))%(2*M);
					for (ll j3 = 0; j3 < 3; j3++) {
						S[3] = (S[j3] + optimal_delta(F, T, i3))%(2*M);
						ll s = simulate(F, T, S);
						res = min(res, s);
						//cout << S[0] << " " << S[1] << " " << S[2] << " " << S[3] << endl;
						//cout << s << endl;
						//cout << endl;
					}
				}
			}
		}
	}
	cout << res << endl;
}

signed main() {
    // DON'T MIX "scanf" and "cin"!
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout << fixed << setprecision(20);
    run();
    return 0;
}
