#!/usr/bin/env python3
import math
import random
import string
import sys

# Init seed with first argument
random.seed(int(sys.argv[1]))

text_type = sys.argv[2]
if text_type == "round-robin":
    text_type = "".join(c * 6 for _ in range(int(math.ceil(3e5 / 26 / 6))) for c in string.ascii_lowercase)[:int(3e5)]
print(random.randrange(0, 2**32), text_type)

# 26 * 5 = 130 words
single_letter_words = [c * i for c in string.ascii_lowercase for i in range(6, 11)]

# 26 * 25 * 5 * 3 = 9750 words
double_letter_words = [
    c * (i // 2 + j) + d * (i - i // 2 - j)
    for c in string.ascii_lowercase
    for d in string.ascii_lowercase
    if c != d
    for i in range(6, 11)
    for j in range(-1, 2)
]

words = single_letter_words + sorted(random.choices(double_letter_words, k=4870))
print(*words, sep="\n")
