#include "validation.h"

using namespace std;

// Read the seed, the type (human/llm/<fixed string>), and the word list.

int main(int argc, char* argv[]) {
    InputValidator v(argc, argv);

    v.read_integer("seed", 0, (1L << 32) - 1);
    v.space();
    string text_type = v.read_string("text_type", 3, 3e5, "abcdefghijklmnopqrstuvwxyz");
    v.check(text_type == "human" || text_type == "llm" || text_type.length() == 3e5,
            "invalid text_type");
    v.newline();
    for(int i = 0; i < 5000; i++) {
        v.read_string("word", 6, 10, "abcdefghijklmnopqrstuvwxyz");
        v.newline();
    }
}
