#!/usr/bin/env python3

n, m = map(int, input().split())

N: list[list[int]] = [[] for _ in range(n)]
for _ in range(m):
    u, v = map(lambda x: int(x) - 1, input().split())
    N[u].append(v)
    N[v].append(u)

Q = [0]
pred: dict[int, int] = { 0: 0 }
dist: dict[int, int] = { 0: 0 }
while Q:
    R: list[int] = []
    endpoints: tuple[int, int] | None = None # the endpoints of the walk's eccentric edge
    for u in Q:
        for v in N[u]:
            if v not in dist:
                pred[v] = u
                dist[v] = dist[u] + 1
                R.append(v)
                continue
            if dist[v] < dist[u]: # v is u's parent if the bfs tree
                continue
            if dist[v] == dist[u] or endpoints is None: # priviledge cross edge in bfs tree
                endpoints = u, v
    if endpoints is None: # still only explored a tree: explore next layer
        Q = R
    else: # found the answer; unspool predecessor pointers, print, and exit
        pu, pv = [endpoints[0]], [endpoints[1]]
        for path in [pu,  pv]:
            while path[-1] != 0:
                path.append(pred[path[-1]])
        print(len(pu) + len(pv))
        print(*(w + 1 for w in pu[::-1] + pv))
        exit()
print("impossible") # the connected component of 1 is a tree
