#include <iostream>
#include <vector>
#include <unordered_map>
#include <tuple>

// For each length k>0 and oriented edge uv, count the digon-free s,uv-walks using k edges,
// i.e., the digon-free walks from s whose last edge is u->v.
// Worst case O(dm), where d is the output size, bounded by O(nm)

using namespace std;

// Source: https://www.geeksforgeeks.org/cpp/how-to-create-an-unordered_map-of-pairs-in-c/
// A hash function used to hash a pair of any kind
struct hash_pair {
    template <class T1, class T2>
    size_t operator()(const pair<T1, T2>& p) const
    {
        // Hash the first element
        size_t hash1 = hash<T1>{}(p.first);
        // Hash the second element
        size_t hash2 = hash<T2>{}(p.second);
        // Combine the two hash values
        return hash1
               ^ (hash2 + 0x9e3779b9 + (hash1 << 6)
                  + (hash1 >> 2));
    }
};

int main() {
    int n, m;
    cin >> n >> m;
    using Arc = pair<int, int>;
    vector<vector<int>> N(n + 1); // ignore entry 0

    for (int i = 0; i < m; ++i) {
        int u, v;
        cin >> u >> v;
        N[u].push_back(v);
        N[v].push_back(u);
    }

    vector<unordered_map<Arc, Arc, hash_pair>> pred(2 * n);
    for (int v : N[1]) {
        pred[1][make_pair(1, v)] = make_pair(1, 1);
    }

    for (int k = 2; k < 2 * n - 1; ++k) {
        pred[k].clear();
        for (const auto& [key, value] : pred[k - 1]) {
            auto [u, v] = key;
            for (int w : N[v]) {
                if (u == w) { // u, v, w is a digon! skip it.
                    continue;
                }
                pred[k][make_pair(v, w)] = make_pair(u, v);
                if (w == 1) {
                    // found it, now print answer
                    cout << k + 1 << endl;
                    while (k) {
                        cout << w << endl;
                        tie(v, w) = pred[k][make_pair(v, w)];
                        k -= 1;
                    }
                    cout << 1 << endl;
                    return 0;
                }
            }
        }
    }
    cout << "impossible" << endl;
    return 0;
}
