fun main() {
    // Read the input
    val (n, w) = readln().split(" ").map { it.toInt() }
    val p = IntArray(n)
    val t = IntArray(n)
    for (i in 0..<n) {
        val ps = readln().split(" ").map { it.toInt() }
        p[i] = ps[0]
        t[i] = ps[1]
    }

    // Binary search for the time, and check if we can do it in that time
    var low = 0.0
    var up = 3e9
    for (times in 0..99) {
        val time = (low + up) / 2

        // Greedily use all time for each mill and check
        // how much we can grind in that time
        var total = 0.0
        for (i in 0..<n) {
            val grindTime = time - t[i] * 2
            if (grindTime < 0) continue
            total += grindTime * p[i]
        }

        // Is this enough time? Then we might use less,
        // else we need more
        if (total >= w) up = time
        else low = time
    }
    println(low)
}