
#include <iostream>
#include <fstream>
#include <vector>
#include <algorithm>

long long MAXN = 9241, MAXX = 10000;

int main(){
    long long BASE = 1, OFFS = 2*MAXX*MAXX*MAXX, MAXCOUNT = (2*MAXX+1)*(2*MAXX+2)/2;
    while ((1<<BASE) <= 2*MAXX) ++BASE;
    std::vector<long long> sumof2;
    sumof2.reserve(MAXCOUNT);
    for (long long a = -MAXX; a <= MAXX; ++a) for (long long b = a; b <= MAXX; ++b) sumof2.push_back(((a*a*a+b*b*b+OFFS)<<BASE)+(a+MAXX));
    std::sort(sumof2.begin(), sumof2.end());
    std::vector<long long> sum(MAXCOUNT);
    std::vector<int> as(MAXCOUNT);
    int next = 0;
    for (int i = 0; i < MAXCOUNT; ++i) if (next == 0 || (sumof2[i]>>BASE) > sum[next-1]+OFFS){
        sum[next] = (sumof2[i]>>BASE)-OFFS;
        as[next] = (sumof2[i]&((1<<BASE)-1))-MAXX;
        ++next;
    }
    sumof2.clear();
    sum.resize(next);
    as.resize(next);
    std::vector<int> bs(next);
    for (long long i = 0; i < next; ++i){
        long long a = as[i];
        long long b3 = sum[i]-a*a*a;
        long long mini = -MAXX, maxi = MAXX;
        while (mini < maxi){
            long long midi = mini+maxi;
            midi = (midi-(midi&1))/2;
            if (midi*midi*midi < b3) mini = midi+1;
            else maxi = midi;
        }
        bs[i] = mini;
    }
    
    std::vector<std::vector<long long>> solutions(MAXN+1);
    for (long long n = 1; n <= MAXN; ++n){
        long long x = n % 6;
        while (x*x*x < n) x += 6;
        long long k = (x*x*x-n)/6;
        solutions[n] = {x, k, k, -k-1, -k+1};
    }
    
    int from = 0, to = 0;
    for (int i = next-1; i >= 0; --i){
        while (from < next && sum[i]+sum[from] <= 0) ++from;
        while (to < next && sum[i]+sum[to] <= MAXN) ++to;
        for (int j = from; j < to; ++j) solutions[sum[i]+sum[j]] = {as[i], bs[i], as[j], bs[j]};
    }
    
    from = to = 0;
    for (long long c = MAXX; c >= -MAXX; --c){
        while (from < next && c*c*c+sum[from] <= 0) ++from;
        while (to < next && c*c*c+sum[to] <= MAXN) ++to;
        for (int j = from; j < to; ++j) solutions[c*c*c+sum[j]] = {c, as[j], bs[j]};
    }
    
    for (int i = 0; i < next; ++i) if (sum[i] > 0 && sum[i] <= MAXN) solutions[sum[i]] = {as[i], bs[i]};
    for (long long x = 1; x*x*x <= MAXN; ++x) solutions[x*x*x] = {x};
    
    /*
    std::ofstream file;
    file.open("solutions.txt");
    for (int i = 0; i <= MAXN; ++i){
        file << i << ' ' << solutions[i].size() << ' ' << ':';
        for (long long x : solutions[i]) file << ' ' << x;
        file << std::endl;
    }
    file.close();
    std::vector<int> counts(6);
    for (int i = 0; i <= MAXN; ++i) ++counts[solutions[i].size()];
    std::cout << counts[0] << ' ' << counts[1] << ' ' << counts[2] << ' ' << counts[3] << ' ' << counts[4] << ' ' << counts[5] << std::endl;
    */
    
    long long n;
    std::cin >> n;
    std::cout << solutions[n].size();
    for (long long x : solutions[n]) std::cout << ' ' << x;
    std::cout << std::endl;
    
    return 0;
}
