#!/usr/bin/env python3
import sys

if len(sys.argv) != 3:
    print(f"Usage: {sys.argv[0]} input.txt output.tex")
    sys.exit(2)

sys.stdin = open(sys.argv[1])
sys.stdout = open(sys.argv[2], "w")

n = int(input())
grid = []
for _ in range(n):
    input()
    grid.append([input() for _ in range(n)])

print(r"""\documentclass[tikz,border=10pt]{standalone}
\usetikzlibrary{3d} % https://tikz.dev/library-3d

\begin{document}
\begin{tikzpicture}[every node/.style={font=\ttfamily\Large}]""")
for i in reversed(range(1, n + 1)):
    print(rf"""
\begin{{scope}}[canvas is xy plane at z={i}]
    \draw[black!10,thin] (1, 1) grid ({n}, {n});
\end{{scope}}""")

color = {"B": "black", "A": "red", "P": "green!80!black", "C": "blue"}

for i, plane in enumerate(grid, start=1):
    print(rf"""
\begin{{scope}}[canvas is xz plane at y={i}]
    \draw[black!10,thin] (1, 1) grid ({n}, {n});""")

    for j, row in enumerate(plane, start=1):
        for k, cell in enumerate(row, start=1):
            print(rf"    \node[text={color[cell]}] at ({k}, {j}) {{{cell}}};")
    print(r"\end{scope}")

print(r"\end{tikzpicture}")
print(r"\end{document}")
