import java.io.*;
import java.util.*;

public class MikeFastScanner {
    static final class FastScanner {
        private final InputStream in;
        private final byte[] buffer = new byte[1 << 16];
        private int ptr = 0, len = 0;

        FastScanner(InputStream is) {
            in = is;
        }

        private int read() throws IOException {
            if (ptr >= len) {
                len = in.read(buffer);
                ptr = 0;
                if (len <= 0) return -1;
            }
            return buffer[ptr++];
        }

        int nextInt() throws IOException {
            int c, s = 1, x = 0;
            do {
                c = read();
            } while (c <= 32);
            if (c == '-') {
                s = -1;
                c = read();
            }
            while (c > 32) {
                x = x * 10 + (c - '0');
                c = read();
            }
            return x * s;
        }

        String next() throws IOException {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = read();
            } while (c <= 32);
            while (c > 32) {
                sb.append((char) c);
                c = read();
            }
            return sb.toString();
        }
    }

    static final class Point {
        int x, y, z;

        Point() {
        }

        Point(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        void set(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static void main(String[] args) throws Exception {
        FastScanner sc = new FastScanner(System.in);
        int n = sc.nextInt();
        String[][] g = new String[n][n];
        for (int x = 0; x < n; ++x) {
            sc.next(); // read hyphen
            for (int y = 0; y < n; ++y) g[x][y] = sc.next();
        }

        int cap = n * n * n;
        Point[] B = new Point[cap];
        Point[] A = new Point[cap];
        Point[] P = new Point[cap];
        Point[] C = new Point[cap];
        for (int i = 0; i < cap; ++i) {
            B[i] = new Point();
            A[i] = new Point();
            P[i] = new Point();
            C[i] = new Point();
        }
        int Bn = 0, An = 0, Pn = 0, Cn = 0;
        for (int x = 0; x < n; ++x)
            for (int y = 0; y < n; ++y)
                for (int z = 0; z < n; ++z) {
                    char ch = g[x][y].charAt(z);
                    switch (ch) {
                        case 'B':
                            B[Bn++].set(x, y, z);
                            break;
                        case 'A':
                            A[An++].set(x, y, z);
                            break;
                        case 'P':
                            P[Pn++].set(x, y, z);
                            break;
                        case 'C':
                            C[Cn++].set(x, y, z);
                            break;
                    }
                }
        // shrink counts by just tracking sizes
        int X = n; // will be decremented to n-1 below in C++ code; but arrays use 0..n inclusive length so use N1 = n
        int N1 = n; // keep original n for coords
        n = n - 1; // now n matches C++ after --n
        int dimX = n + 1; // 0..n
        int dimY = 2 * n + 1; // -n..n
        int dimZ = 2 * n + 1; // -n..n
        int shift = 2 * n * n;
        int dimD = 5 * n * n + 1;
        long total = 1L * dimX * dimY * dimZ * dimD;
        int size = (int) total;
        int[] planesB = new int[size];
        int[] planesC = new int[size];

        // index helper
        final int fn = n;
        final int fdimY = dimY;
        final int fdimZ = dimZ;
        final int fdimD = dimD;
        final int fshift = shift;
        for (int x = 0; x <= n; ++x) {
            for (int y = -n; y <= n; ++y) {
                int yidx = y + n;
                for (int z = -n; z <= n; ++z) {
                    int zidx = z + n;
                    for (int i = 0; i < Bn; ++i) {
                        Point b = B[i];
                        int dot = x * b.x + y * b.y + z * b.z + fshift;
                        int idx = index(x, yidx, zidx, dot, fdimY, fdimZ, fdimD);
                        planesB[idx]++;
                    }
                    for (int i = 0; i < Cn; ++i) {
                        Point c = C[i];
                        int dot = x * c.x + y * c.y + z * c.z + fshift;
                        int idx = index(x, yidx, zidx, dot, fdimY, fdimZ, fdimD);
                        planesC[idx]++;
                    }
                }
            }
        }

        long ans = 0;
        for (int ia = 0; ia < An; ++ia) {
            Point a = A[ia];
            for (int ip = 0; ip < Pn; ++ip) {
                Point p = P[ip];
                int sgn = (p.x < a.x) ? -1 : 1;
                int dx = sgn * (p.x - a.x);
                int dy = sgn * (p.y - a.y);
                int dz = sgn * (p.z - a.z);
                int x = dx;
                int yidx = dy + n;
                int zidx = dz + n;
                int dotA = dx * a.x + dy * a.y + dz * a.z + shift;
                int dotP = dx * p.x + dy * p.y + dz * p.z + shift;
                int idxA = index(x, yidx, zidx, dotA, dimY, dimZ, dimD);
                int idxP = index(x, yidx, zidx, dotP, dimY, dimZ, dimD);
                ans += 1L * planesB[idxA] * planesC[idxP];
            }
        }
        System.out.println(ans);
    }

    static int index(int x, int yidx, int zidx, int dot, int dimY, int dimZ, int dimD) {
        long idx = (((long) x * dimY + yidx) * dimZ + zidx) * (long) dimD + dot;
        return (int) idx;
    }
}
