#!/usr/bin/env python3


class Point:
    def __init__(self, x=0, y=0, z=0):
        self.x = x
        self.y = y
        self.z = z

    def set_xyz(self, x, y, z):
        self.x = x
        self.y = y
        self.z = z


n = int(input())
input()  # Read first hyphen
g = [s.strip().split("\n") for s in __import__("sys").stdin.read().split("-")]

B = [Point() for _ in range(n * n * n)]
A = [Point() for _ in range(n * n * n)]
P = [Point() for _ in range(n * n * n)]
C = [Point() for _ in range(n * n * n)]
Bn = An = Pn = Cn = 0

for x in range(n):
    for y in range(n):
        for z in range(n):
            if g[x][y][z] == "B":
                B[Bn].set_xyz(x, y, z)
                Bn += 1
            elif g[x][y][z] == "A":
                A[An].set_xyz(x, y, z)
                An += 1
            elif g[x][y][z] == "P":
                P[Pn].set_xyz(x, y, z)
                Pn += 1
            elif g[x][y][z] == "C":
                C[Cn].set_xyz(x, y, z)
                Cn += 1

B = B[:Bn]
A = A[:An]
P = P[:Pn]
C = C[:Cn]

n -= 1
planes_B = [[[[0] * (5 * n * n + 1) for _ in range(2 * n + 1)] for _ in range(2 * n + 1)] for _ in range(n + 1)]
planes_C = [[[[0] * (5 * n * n + 1) for _ in range(2 * n + 1)] for _ in range(2 * n + 1)] for _ in range(n + 1)]

for x in range(n + 1):
    for y in range(-n, n + 1):
        for z in range(-n, n + 1):
            for b in B:
                planes_B[x][y + n][z + n][x * b.x + y * b.y + z * b.z + 2 * n * n] += 1
            for c in C:
                planes_C[x][y + n][z + n][x * c.x + y * c.y + z * c.z + 2 * n * n] += 1

ans = 0
for a in A:
    for p in P:
        sgn = 1 - 2 * (p.x < a.x)
        d = Point(sgn * (p.x - a.x), sgn * (p.y - a.y), sgn * (p.z - a.z))
        ans += (
            planes_B[d.x][d.y + n][d.z + n][d.x * a.x + d.y * a.y + d.z * a.z + 2 * n * n]
            * planes_C[d.x][d.y + n][d.z + n][d.x * p.x + d.y * p.y + d.z * p.z + 2 * n * n]
        )

print(ans)
