#include <iostream>
#include <string>
#include <vector>

struct point{
    int x, y, z;
    point(int x_ = 0, int y_ = 0, int z_ = 0) : x(x_), y(y_), z(z_) {}
    void set_xyz(int x_, int y_, int z_) {x=x_; y=y_; z=z_;}
};

int main(){
    int n;
    std::string hyphen;
    std::cin >> n;
    std::vector<std::vector<std::string>> g(n, std::vector<std::string>(n));
    for (int x = 0; x < n; ++x) {
        std::cin >> hyphen;
        for (int y = 0; y < n; ++y) std::cin >> g[x][y];
    }
    
    std::vector<point> B(n*n*n), A(n*n*n), P(n*n*n), C(n*n*n);
    int Bn = 0, An = 0, Pn = 0, Cn = 0;
    for (int x = 0; x < n; ++x) for (int y = 0; y < n; ++y) for (int z = 0; z < n; ++z){
        switch(g[x][y][z]){
            case 'B':
            B[Bn++].set_xyz(x,y,z);
            break;
            case 'A':
            A[An++].set_xyz(x,y,z);
            break;
            case 'P':
            P[Pn++].set_xyz(x,y,z);
            break;
            case 'C':
            C[Cn++].set_xyz(x,y,z);
            break;
        }
    }
    B.resize(Bn);
    A.resize(An);
    P.resize(Pn);
    C.resize(Cn);
    
    --n;
    std::vector<std::vector<std::vector<std::vector<int>>>> planes_B(n+1, std::vector<std::vector<std::vector<int>>>(2*n+1, std::vector<std::vector<int>>(2*n+1, std::vector<int>(5*n*n+1))));
    std::vector<std::vector<std::vector<std::vector<int>>>> planes_C(n+1, std::vector<std::vector<std::vector<int>>>(2*n+1, std::vector<std::vector<int>>(2*n+1, std::vector<int>(5*n*n+1))));
    for (int x = 0; x <= n; ++x) for (int y = -n; y <= n; ++y) for (int z = -n; z <= n; ++z){
        for (const point &b : B) ++planes_B[x][y+n][z+n][x*b.x+y*b.y+z*b.z+2*n*n];
        for (const point &c : C) ++planes_C[x][y+n][z+n][x*c.x+y*c.y+z*c.z+2*n*n];
    }
    
    long long ans = 0;
    for (const point &a : A) for (const point &p : P){
        int sgn = 1-2*(p.x<a.x);
        point d(sgn*(p.x-a.x),sgn*(p.y-a.y),sgn*(p.z-a.z));
        ans += planes_B[d.x][d.y+n][d.z+n][d.x*a.x+d.y*a.y+d.z*a.z+2*n*n] * planes_C[d.x][d.y+n][d.z+n][d.x*p.x+d.y*p.y+d.z*p.z+2*n*n];
    }
    std::cout << ans << std::endl;
    
    return 0;
}
