# 1. Loop over all directions
# 2. For each direction, count #B and #C in each plane.
# 3. For each projection, count #BA and #PC.
#
# This is 8*n^6, but slow because of python dicts.
import math

n = int(input())
grid = []
for _ in range(n):
    input()
    grid.append([input() for _ in range(n)])

dirs = []
for di in range(0, n):
    for dj in range(-(n - 1) if di > 0 else 0, n):
        for dk in range(-(n - 1) if di > 0 or dj > 0 else 0, n):
            if di == 0 and dj == 0 and dk == 0:
                continue
            g = math.gcd(abs(di), math.gcd(abs(dj), abs(dk)))
            if g == 1 or g == -1:
                dirs.append((di, dj, dk))

ps = []
for i in range(n):
    for j in range(n):
        for k in range(n):
            ps.append((i, j, k))

ans = 0

## <(2n)^3 directions
for d in dirs:
    ll = d[0] ** 2 + d[1] ** 2 + d[2] ** 2

    # For each projection, the positions of A and P.
    proj = {}
    # Count for each plane #B and #C
    planes = {}
    # n^3 points
    for p in ps:
        char = grid[p[0]][p[1]][p[2]]
        if char in "BC":
            dot = d[0] * p[0] + d[1] * p[1] + d[2] * p[2]
            # Plane
            if dot not in planes:
                planes[dot] = [0, 0]
            if char == "B":
                planes[dot][0] += 1
            if char == "C":
                planes[dot][1] += 1

    for p in ps:
        char = grid[p[0]][p[1]][p[2]]
        if char in "AP":
            dot = d[0] * p[0] + d[1] * p[1] + d[2] * p[2]
            # Projection
            projection = (
                (ll * p[0] - d[0] * dot),
                (ll * p[1] - d[1] * dot),
                (ll * p[2] - d[2] * dot),
            )

            if dot not in planes:
                continue
            if projection not in proj:
                proj[projection] = [0, 0]
            if char == "A":
                proj[projection][0] += planes[dot][0]
            if char == "P":
                proj[projection][1] += planes[dot][1]

    # For each projection
    for projection, (BA, PC) in proj.items():
        ans += BA * PC

print(ans)
