# 1. Loop over all directions
# 2. For each direction, count #B and #C in each plane.
# 3. For each projection, count #BA and #PC.
#
# This is 8*n^6, but slow because of python dicts.
import math

n = int(input())
grid = []
for _ in range(n):
    input()
    grid.append([input() for _ in range(n)])

dirs = []
for di in range(0, n):
    for dj in range(-(n - 1) if di > 0 else 0, n):
        for dk in range(-(n - 1) if di > 0 or dj > 0 else 0, n):
            if di == 0 and dj == 0 and dk == 0:
                continue
            g = math.gcd(abs(di), math.gcd(abs(dj), abs(dk)))
            if g == 1 or g == -1:
                dirs.append((di, dj, dk))

B = []
A = []
P = []
C = []

for i in range(n):
    for j in range(n):
        for k in range(n):
            c = grid[i][j][k]
            if c == "B":
                B.append((i, j, k))
            if c == "A":
                A.append((i, j, k))
            if c == "P":
                P.append((i, j, k))
            if c == "C":
                C.append((i, j, k))

ans = 0

X = 10 * n**4

## <(2n)^3 directions
for d in dirs:
    ll = d[0] ** 2 + d[1] ** 2 + d[2] ** 2

    # For each projection, the positions of A and P.
    proj = {}
    # Count for each plane #B and #C
    planes = {}
    # n^3 points
    for p in B:
        dot = d[0] * p[0] + d[1] * p[1] + d[2] * p[2]
        # Plane
        if dot * 2 not in planes:
            planes[dot * 2] = 0
        planes[dot * 2] += 1
    for p in C:
        dot = d[0] * p[0] + d[1] * p[1] + d[2] * p[2]
        if dot * 2 + 1 not in planes:
            planes[dot * 2 + 1] = 0
        planes[dot * 2 + 1] += 1

    for p in A:
        dot = d[0] * p[0] + d[1] * p[1] + d[2] * p[2]
        # Projection
        projection = (
            (ll * p[0] - d[0] * dot),
            +(ll * p[1] - d[1] * dot),
            +(ll * p[2] - d[2] * dot),
        )

        if 2 * dot not in planes:
            continue
        if projection not in proj:
            proj[projection] = [0, 0]
        proj[projection][0] += planes[dot * 2]
    for p in P:
        dot = d[0] * p[0] + d[1] * p[1] + d[2] * p[2]
        # Projection
        projection = (
            (ll * p[0] - d[0] * dot),
            +(ll * p[1] - d[1] * dot),
            +(ll * p[2] - d[2] * dot),
        )

        if 2 * dot + 1 not in planes:
            continue
        if projection not in proj:
            proj[projection] = [0, 0]
        proj[projection][1] += planes[dot * 2 + 1]

    # For each projection
    for projection, (BA, PC) in proj.items():
        ans += BA * PC

print(ans)
