import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

/**
 * Solution to Elven Efficiency.
 *
 * @author vanb
 */
public class elven_vanb
{
    
    /** The Input. */
    private static Scanner sc;
    
    /** The Output. */
    private static PrintStream ps;
        
    /**
     * Do it.
     */
    private void doit()
    {
        // We'll keep a list of multiples for each potential value of k
        List<Integer> multiples[] = new ArrayList[1500000];
        for( int i=0; i<multiples.length; i++ ) multiples[i] = new ArrayList<Integer>();
        
        // Go through all potential values of a, put them in the list for each of their multiples
        for( int i=1; i<1500000; i++ ) for( int k=2; k*k<=i; k++ ) if( i%k==0 )
        {
            multiples[k].add( i );
        }
        
        int n = sc.nextInt();
        int m = sc.nextInt();
        
        // Read the a values. We only need to know the count of each one.
        int counts[] = new int[1500000];
        Arrays.fill( counts, 0 );
        for( int i=0; i<n; i++ ) ++counts[sc.nextInt()];
        
        // Go through the k values
        int stones = 0;
        for( int i=0; i<m; i++ )
        {
            int k = sc.nextInt();
            
            // Determine the number of a values that need to be incremented
            for( int multiple : multiples[k] )
            {
                // We need this many stones
                stones += counts[multiple];
                
                // Adjust the counts
                counts[multiple+1] += counts[multiple];
                counts[multiple] = 0;
            }
        }
        
        ps.println( stones );
    }
        
    /**
     * The main method.
     *
     * @param args the arguments
     * @throws Exception the exception
     */
    public static void main( String[] args ) throws Exception
    {
        sc = new Scanner( System.in );
        ps = System.out;
        
        new elven_vanb().doit();
    }

}
