import java.io.OutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.BufferedWriter;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.io.IOException;
import java.util.TreeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import java.io.Writer;
import java.io.OutputStreamWriter;
import java.io.InputStream;

/**
 * Built using CHelper plug-in
 * Actual solution is at the top
 *
 * @author lewin
 */
public class elven_lewin {
    public static void main(String[] args) {
        InputStream inputStream = System.in;
        OutputStream outputStream = System.out;
        InputReader in = new InputReader(inputStream);
        OutputWriter out = new OutputWriter(outputStream);
        ElvenEfficiency solver = new ElvenEfficiency();
        solver.solve(1, in, out);
        out.close();
    }

    static class ElvenEfficiency {
        int n;
        int m;
        int[] a;
        int[] k;
        List<Integer>[] divs;
        TreeSet<Integer>[] ts;
        HashMap<Integer, Integer>[] mp;

        int getNext(int idx, int value) {
            Integer w = ts[value].ceiling(idx);
            if (w == null) return m;
            return w;
        }

        public void solve(int testNumber, InputReader in, OutputWriter out) {
            n = in.nextInt();
            m = in.nextInt();
            a = in.readIntArray(n);
            k = in.readIntArray(m);
            mp = new HashMap[m];
            for (int i = 0; i < m; i++) mp[i] = new HashMap<>();
            ts = new TreeSet[Math.max(AUtils.max(k), AUtils.max(a) + m) + 1];
            for (int i = 0; i < ts.length; i++) ts[i] = new TreeSet<>();
            for (int i = 0; i < m; i++) {
                ts[k[i]].add(i);
            }
            divs = LUtils.genArrayList(AUtils.max(a) + m + 1);
            for (int i = 2; i < divs.length; i++)
                for (int j = i; j < divs.length; j += i)
                    divs[j].add(i);
            long ans = 0;
            for (int i = 0; i < n; i++) {
                ans += dfs(0, a[i]) - a[i];
            }
            out.println(ans);
        }

        int dfs(int idx, int value) {
            if (idx == m) return value;
            Integer x = mp[idx].get(value);
            if (x != null) return x;
            int midx = m;
            for (int g : divs[value])
                midx = Math.min(midx, getNext(idx, g));
            if (midx == m) return value;
            int res = dfs(midx + 1, value + 1);
            mp[idx].put(value, res);
            return res;
        }

    }

    static class AUtils {
        public static int max(int[] arr) {
            int res = arr[0];
            for (int x : arr) if (x > res) res = x;
            return res;
        }

    }

    static class LUtils {
        public static <E> List<E>[] genArrayList(int size) {
            return Stream.generate(ArrayList::new).limit(size).toArray(List[]::new);
        }

    }

    static class InputReader {
        private InputStream stream;
        private byte[] buf = new byte[1 << 16];
        private int curChar;
        private int numChars;

        public InputReader(InputStream stream) {
            this.stream = stream;
        }

        public int[] readIntArray(int tokens) {
            int[] ret = new int[tokens];
            for (int i = 0; i < tokens; i++) {
                ret[i] = nextInt();
            }
            return ret;
        }

        public int read() {
            if (this.numChars == -1) {
                throw new InputMismatchException();
            } else {
                if (this.curChar >= this.numChars) {
                    this.curChar = 0;

                    try {
                        this.numChars = this.stream.read(this.buf);
                    } catch (IOException var2) {
                        throw new InputMismatchException();
                    }

                    if (this.numChars <= 0) {
                        return -1;
                    }
                }

                return this.buf[this.curChar++];
            }
        }

        public int nextInt() {
            int c;
            for (c = this.read(); isSpaceChar(c); c = this.read()) {
                ;
            }

            byte sgn = 1;
            if (c == 45) {
                sgn = -1;
                c = this.read();
            }

            int res = 0;

            while (c >= 48 && c <= 57) {
                res *= 10;
                res += c - 48;
                c = this.read();
                if (isSpaceChar(c)) {
                    return res * sgn;
                }
            }

            throw new InputMismatchException();
        }

        public static boolean isSpaceChar(int c) {
            return c == 32 || c == 10 || c == 13 || c == 9 || c == -1;
        }

    }

    static class OutputWriter {
        private final PrintWriter writer;

        public OutputWriter(OutputStream outputStream) {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        }

        public OutputWriter(Writer writer) {
            this.writer = new PrintWriter(writer);
        }

        public void close() {
            writer.close();
        }

        public void println(long i) {
            writer.println(i);
        }

    }
}

