#!/usr/bin/env python3

# plot jumpingpath input data

import argparse
import re
import subprocess

def dfs_iterative(tree, label, longest, length, multiplicity):
    MOD = 11092019
    stack = [(0, None)]

    while stack:
        u, loc = stack.pop()
        u_lbl = label[u]

        if loc is not None:
            longest[loc].pop()
            if len(longest[loc]) == 1:
                longest.pop()
        else:
            x = len(longest)
            while u_lbl < longest[x-1][-1][0]: # FIXME: do a bisect
                x -= 1

            length[u] = x
            if x == len(longest):
                longest.append([(-1, 1, 0)])

            y = len(longest[x-1])
            while 1 < y and longest[x-1][y-1][0] <= u_lbl: # FIXME: do a bisect
                y -= 1

            if y < len(longest[x-1]) - 1:
                m = (longest[x-1][-1][2] - longest[x-1][y-1][2]) % MOD
            else:
                m = longest[x-1][-1][1]
            multiplicity[u] = m

            longest[x].append((u_lbl, m, (longest[x][-1][2] + m) % MOD))

            stack.append((u, x))
            for v in tree[u]:
                stack.append((v, None))

def solve(label, parent):
    # read the input
    n = len(label)
    tree = [[] for _ in range(n)]
    for u, p in enumerate(parent, 1):
        tree[p].append(u)

    longest = [[(-1, 1, 0)]] # sentinel

    length = [0] * n # the length of the longest path ending at each node
    multiplicity = [0] * n # number of longest paths ending at each node

    dfs_iterative(tree, label, longest, length, multiplicity)

    return length


def visualize():
    p = argparse.ArgumentParser()
    p.add_argument('--maxn', type=int, default=25, help='maximum number of nodes to render (to avoid absurdly large diagrams)')
    p.add_argument('--type', choices=['svg', 'png', 'jpg', 'pdf'], default='svg')
    p.add_argument('input_files', nargs='+', help='the .in files to render')
    args = p.parse_args()

    for input_filename in args.input_files:
        output_filename = re.sub('[.]in$', '.' + args.type, input_filename)

        print('rendering {} into {}'.format(input_filename, output_filename))

        with open(input_filename) as input_file:
            n = int(input_file.readline())

            if n > args.maxn:
                print('skipping rendering {} as the number of nodes is too large ({}; see --maxn)'.format(output_filename, n))
                continue

            labels = [int(input_file.readline()) for _ in range(n)]
            parents = [int(input_file.readline())-1 for _ in range(n-1)]

        lengths = solve(labels, parents)
        print(lengths)
        best = max(lengths)

        graph_lines = ['digraph G {']
        styles = [',style=filled,fillcolor=red' if lengths[u] == best else '' for u in range(n)]
        graph_lines.append('{} [label="{} ({})"{}];'.format(0, labels[0], 0, styles[0]))
        for node, parent in enumerate(parents, 1):
            graph_lines.append('{} [label="{} ({})"{}];'.format(node, labels[node], node, styles[node]))
            graph_lines.append('{} -> {};'.format(parent, node));

        graph_lines.append('}');

        with open(output_filename, 'w') as out:
            p = subprocess.Popen(['dot', '-T', args.type], stdin=subprocess.PIPE, stdout=out)
            graph = '\n'.join(graph_lines)
            print(graph)
            (out, err) = p.communicate(bytes(graph, 'utf-8'))

if __name__ == '__main__':
    visualize()
