#include "testlib.h"
#include <cmath>

using namespace std;

const double EPS = 1E-8;

int main(int argc, char * argv[])
{
    setName("compare two sequences of doubles, max absolute or relative  error = %.7lf", EPS);
    registerTestlibCmd(argc, argv);

    int n = 0;
    double j, p;

    while (!ans.seekEof()) 
    {
        n++;
        j = ans.readDouble();
        p = ouf.readDouble();

        if (isnan(p)) 
         quitf (_wa,"%d%s number: NAN found",n,englishEnding(n).c_str());
        if (isnan(j)) 
         quitf (_fail,"%d%s number: NAN found",n,englishEnding(n).c_str());
        if (isinf(p)) 
         quitf (_wa,"%d%s number: INFINITY found",n,englishEnding(n).c_str());
        if (isinf(j)) 
         quitf (_fail,"%d%s number: INFINITY found",n,englishEnding(n).c_str());

        if (!doubleCompare(j, p, EPS))
        {
            quitf(_wa, "%d%s numbers differ - expected: '%.7lf', found: '%.7lf', error = '%.7lf'",
                n, englishEnding(n).c_str(), j, p, doubleDelta(j, p));
        }
    }

    if (n == 1)
        quitf(_ok, "found '%.7lf', expected '%.7lf', error '%.7lf'", p, j, doubleDelta(j, p));

    quitf(_ok, "%d numbers", n);
}
