/***************************************************************
**
**    ---- Jury's correct C++ solution of the problem ----
**
**                --  "Reserve"  --
**
**  file: solution.cpp
**
**  10 august   2007 - created
**
***************************************************************/

#include <stdio.h>
#include <iostream>

//--------------------------------------------------------------

#define IFN "reserve.in"
#define OFN "reserve.out"

#define N 256
#define oo 1000000000

//--------------------------------------------------------------

using namespace std;

int cost[N][N];

int n, m, source, sink, nusedtobe;
int G[N][N], C[N][N], F[N][N], B[N];
int inq[N], d[N], pi[N], label[N];
int cycle[N];

int neg_cycle()  {
	int i, j, k;

	for(i=1; i<=n; i++)  d[i]=0;
	for(i=1; i<=n; i++)  pi[i]=label[i]=0;
		
	for(k=1; k<n; k++)  {
		for(i=1; i<=n; i++)
			for(j=1; j<=n; j++)
				if(G[i][j]>0&&d[j]>d[i]+C[i][j])  {
					d[j]=d[i]+C[i][j];
					pi[j]=i;					
				}
	}

	for(k=1; k<=n; k++)  {
		label[i=k]=k;
		m=0;		
		cycle[m++]=i;
		for(;;)  {
			i=pi[i];
			cycle[m++]=i;
			if(i==0)  break;
			if(label[i]==k)  return 1;
			label[i]=k;
		}
	}

	return 0;
}

int que[N], W[N];

int augment()  {
	int i, j, h(0), t(0);

	for(i=0; i<=n; i++)  inq[i]=0;

	W[source]=oo;

	for(inq[que[++t]=source]=1; h!=t;)  {		
		
		for(i=que[++h], j=1; j<=n; j++)  {			
			
			if(G[i][j]==0||inq[j]==1)  continue;

			inq[que[++t]=j]=1;			
			pi[j]=i;

			W[j]=W[i];
			if(W[j]>G[i][j])  W[j]=G[i][j];			

			if(j==sink)  {  h=t;  break;  }

		}		
	}

	if(inq[sink]==0)  return 0;

	int width(W[sink]);

	for(j=sink; j!=source; j=i)  {		
		i=pi[j];
		G[i][j]-=width;  F[i][j]+=width;
		G[j][i]+=width;  F[j][i]-=width;
	}
        	
	return width;
}


int find_max_flow_min_cost()  {
	int ans(0), ans1(0), i, j, p, q, width;
	
	while(augment());

	for(i=1; i<=n; i++)  {
		for(j=1; j<=n; j++)
			if(F[i][j]>0)
				ans+=F[i][j]*C[i][j];
	}
        	
	while(neg_cycle()>0)  {
		
		i=m-1;
		p=cycle[i];  q=cycle[i-1];
		width=oo;		

		do  {				
			if(G[p][q]<width)  width=G[p][q];
			i--;
			p=cycle[i];  q=cycle[i-1];
		}  while(p!=cycle[m-1]);

		i=m-1;
		p=cycle[i];  q=cycle[i-1];
		do  {			
			G[p][q]-=width;  G[q][p]+=width;
			F[p][q]+=width;  F[q][p]-=width;
			ans+=C[p][q]*width;
			i--;
			p=cycle[i];  q=cycle[i-1];
		}  while(p!=cycle[m-1]);
	}

	for(i=1; i<=n; i++)  {
		for(j=1; j<=n; j++)
			if(F[i][j]>0)
				ans1+=F[i][j]*C[i][j];
	}		


	if(ans!=ans1)  printf("Botva");

	
	return ans;
}

int main()  {
	int i, j, k;
	freopen(IFN, "r", stdin);
	freopen(OFN, "w", stdout);
		
	cin >> n;
	
	for(i = 1; i <= n; i++) {
		for(j = i; j <= n; j++) {
			cin >> k;
			C[i][j+1] = k;
			C[j+1][i] = -k;
			G[i][j+1] = oo;
		}		
	}
	
	source = n+2;
	sink = n+3;
	
	for(i=1; i<=n; i++) 
		cin >> B[i];				
	
	for(i=1; i<=n+1; i++) {
		k = B[i] - B[i-1];
		if(k > 0)
			G[source][i] = k;
		else
			G[i][sink] = -k;
		if(i>1) {
			G[i][n+2+i] = oo;
			G[n+2+i][i-1] = oo;
		}
	}
		
	n = 2*n+3;	
	cout << find_max_flow_min_cost() << endl;	
	n = (n-3)/2+1;

	for(i=1; i<=n; i++) {
		for(j=i+1; j<=n; j++) {			
				cout << F[i][j] << " ";
		}			
		cout << endl;
	}
		
	
	return 0;
}

//-- End of file -----------------------------------------------
