#define _CRT_SECURE_NO_WARNINGS

#include <cstdio>
#include <cmath>
#include <cstring>
#include <algorithm>
#include <set>
#include <map>
#include <vector>
#include <string>
#include <iostream>
#include <sstream>
#include <ctime>
#include <cassert>

using namespace std;

typedef long long i64;
typedef unsigned int u32;
typedef unsigned short u16;
typedef unsigned char u8;
const int inf = 0x7FFFFFFF;

template<class T> int size(const T& a) {
	return (int)a.size();
}
template<class T> T sqr(const T& a) {
	return a * a;
}
const int max_e = 20001, max_n = 100;
struct Edge {
	double p, dp;
	int v;
	int f;
	int fu;
	Edge* par;
	void Init(int v, int fu, Edge* par, double p, double dp) {
		this->v = v;
		this->fu = fu;
		this->f = 0;
		this->par = par;
		this->p = p;
		this->dp = dp;
	}
} edges[max_e], *edges_end = edges + 1;
int h[max_n], next_e[max_e];
struct Cus {
	int u;
	int c;
	int v;
	void scan() {
		assert(scanf("%d %d %d", &v, &u, &c) == 3);
		v--;
		assert(1 <= u && u <= 100);
		assert(1 <= c && c <= 10000);
	}
} t[max_n];

double d[max_n];
Edge* p[max_n];
int setid[max_n];
int q[max_n + 1];

int main() {
	freopen("input.txt", "r", stdin);
	FILE* fout = fopen("output.txt", "w");
	int n, s, c, m, crepair;
	assert(scanf("%d %d %d %d", &n, &s, &c, &crepair) == 4);
	assert(1 <= n && n <= 100 && 1 <= s && s <= n && 1 <= c && c <= 100 && 0 <= crepair && crepair <= 10000);
	s--;
	assert(scanf("%d", &m) == 1);
	assert(1 <= m && m <= 100);
	for (int i = 0; i < m; i++) {
		t[i].scan();
		assert(0 <= t[i].v && t[i].v < n);
	}
	int ne;
	assert(scanf("%d", &ne) == 1);
	assert(0 <= ne && ne <= 10000);
	for (int i = 0; i < ne; i++) {
		int v1, v2, ip1, ip2;
		double p1, p2;
		int fu, d;
		assert(scanf("%d %d %d %d %d %d", &v1, &v2, &fu, &d, &ip1, &ip2) == 6);
		assert(v1 != v2 && 1 <= fu && fu <= 100 && 1 <= d && d <= 10000 && 0 <= ip1 && ip1 <= ip2 && ip2 <= 100 && (fu > 1 || ip1 == ip2));
		v1--, v2--;
		p1 = ip1 * 1e-2;
		p2 = ip2 * 1e-2;
		Edge* e1 = edges_end++, *e2 = edges_end++;
		int eid1 = e1 -edges, eid2 = e2 - edges;
		double p = p1, dp = (fu > 1? (p2 - p1) / (fu - 1) : 0);
		p *= crepair;
		p += d;
		dp *= crepair;
		next_e[eid1] = h[v1];
		h[v1] = eid1;
		next_e[eid2] = h[v2];
		h[v2] = eid2;
		e1->Init(v2, fu, e2, p, dp);
		e2->Init(v1, 0, e1, -p + dp, dp);//error
	}
	double res = 0;
	while (c--) {
		for (int i = 0; i < n; i++) {
			setid[i] = 2;
			d[i] = 1e100;
		}
		setid[s] = 1;
		d[s] = 0;
		q[0] = s;
		int top = 0, btm = 1;
		while (top != btm) {
			int i = q[top++];
			setid[i] = 0;
			if (top == n + 1) top = 0;
			for (int w = h[i]; w; w = next_e[w]) {
				Edge &e = edges[w];
				if (e.f < e.fu) {
					if (setid[e.v] == 2 || e.p + d[i] < d[e.v]) {
						switch(setid[e.v]) {
							case 0:
								setid[e.v] = 1;
								top--;
								if (top == -1) top = n;
								q[top] = e.v;
								break;
							case 1:
								break;
							case 2:
								setid[e.v] = 1;
								q[btm++] = e.v;
								if (btm == n + 1) btm = 0;
								break;
						}
						d[e.v] = d[i] + e.p;
						p[e.v] = &e;
					}
				}
			}
		}
		double mx = 0;
		int mi = -1;
		for (int i = 0; i < m; i++) {
			if (t[i].u > 0) {
				double cur = t[i].c - d[t[i].v];
				if (cur > mx) {
					mx = cur;
					mi = i;
				}
			}
		}
		if (mi == -1) {
			break;
		} else {
			int v = t[mi].v;
			t[mi].u--;
			while (v != s) {
				p[v]->f++;
				p[v]->p += p[v]->dp;
				p[v]->par->f--;
				p[v]->par->p -= p[v]->par->dp;
				v  = p[v]->par->v;
			}
			res += mx;
		}
	}
	fprintf(fout, "%.10lf\n", res);

	printf("%.3lf\n", clock() / double(CLOCKS_PER_SEC));
	return 0;
}