from sys import stdout, exit, stderr
from random import shuffle, seed

# seed(1)

def get(i, j):
    print("?", i, j)
    stdout.flush()
    return input()

def below(x1, y1, x2, y2, x3, y3):
    """Assuming x1 < x2, does (x3, y3) lie below the line through ((x1, y1),
    (x2, y2))?"""
    return (y3 - y1)*(x2 - x1) < (x3 - x1)*(y2 - y1)

def above(x1, y1, x2, y2, x3, y3):
    return below(x2, y2, x1, y1, x3, y3)

w, h = [int(x) for x in input().split()]
horizon_pts = []

remaining_points = [(i, j) for i in range(1, w+1) for j in range(1, h+1)]
shuffle(remaining_points)

while len(horizon_pts) < 2:
    if (2, 3) in remaining_points:
        print("in", file=stderr)
    else:
        print("out", file=stderr)
    if len(remaining_points) <= 5:
        for i, j in remaining_points:
            if get(i, j) == "horizon":
                horizon_pts.append((i, j))
        break

    sky_points = []
    sea_points = []

    while len(horizon_pts) < 2:
        i, j = remaining_points.pop()
        cl = get(i, j)
        if cl == "horizon":
            horizon_pts.append((i, j))
        elif cl == "sea":
            sea_points.append((i, j))
        else:
            sky_points.append((i, j))

        if len(sky_points) == 2 or len(sea_points) == 2:
            break

    if len(sea_points) == 2:
        if sea_points[0][0] == sea_points[1][0]:
            continue
        print("sea points:", sea_points, file=stderr)
        if sea_points[0][0] > sea_points[1][0]:
            sea_points = sea_points[1], sea_points[0]

        remaining_points = [(i, j) for i, j in remaining_points if 
                i < sea_points[0][0] or i > sea_points[1][0] or
                above(*(sea_points[0]), *(sea_points[1]), i, j)]
    elif len(sky_points) == 2:
        if sky_points[0][0] == sky_points[1][0]:
            continue
        print("sky points:", sky_points, file=stderr)
        if sky_points[0][0] > sky_points[1][0]:
            sky_points = sky_points[1], sky_points[0]

        remaining_points = [(i, j) for i, j in remaining_points if 
                i < sky_points[0][0] or i > sky_points[1][0] or
                below(*(sky_points[0]), *(sky_points[1]), i, j)]

if len(horizon_pts) < 2:
    print(horizon_pts, file=stderr)
    print(remaining_points, file=stderr)
print("!", *horizon_pts[0], *horizon_pts[1])
