/*
 *	@EXPECTED_RESULTS@: WRONG_ANSWER, TIME_LIMIT_EXCEEDED
 */
#include <algorithm>
#include <queue>
#include <tuple>
#include <unordered_map>
#include <unordered_set>
#include <cassert>
#include <cmath>
#include <iomanip>
#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <algorithm>
using namespace std;

using ll = long long;
using vi = vector<ll>;

struct Edge {
	int u, v;
	ll cost;
	bool operator<(const Edge &o) const {
		return cost > o.cost;
	}
};

int main() {
	ios::sync_with_stdio(false);
	cin.tie(nullptr);

	int n, m;
	cin >> n >> m;
	vector<vector<Edge>> G(n+1);
	while(m--) {
		int t, a;
		cin >> t >> a;
		G[0].push_back({0, t, (ll)a});
		G[t].push_back({t, 0, (ll)a});
	}
	for(int i = 0, b; i < n; ++i) {
		cin >> b;
		int l = i+1, r = (i+1)%n + 1;
		G[l].push_back({l, r, (ll)b});
		G[r].push_back({r, l, (ll)b});
	}

	priority_queue<Edge> pq;
	for (Edge e : G[0]) pq.push(e);
	vi seen(n+1, 0);
	seen[0] = 1;
	ll ans = 0LL;
	while (!pq.empty()) {
		Edge e = pq.top(); pq.pop();
		ans += e.cost;
		for (Edge f : G[e.v])
			if (!seen[e.v])
				pq.push(f);
		seen[e.v] = 1;
	}
	cout << ans << endl;
}
