import java.util.*;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class ragnar_tree {

	static class Edge {
		int v;
		long w;
		Edge(int _v, long _w) {
			v = _v;
			w = _w;
		}
	};

	static int n, m, q;
	static ArrayList<Edge>[] g;
	static Long[] d;
	static ArrayList<Long> e = new ArrayList();

	static void dfs(int u){
		for(Edge f : g[u]){
			int v = f.v;
			long w = f.w;
			long dv = d[u] ^ w;
			if(d[v] == null){
				d[v] = dv;
				dfs(v);
			} else {
				long c = d[v] ^ dv;
				for(Long x : e)
					if((c^x) < x) c ^= x;
				boolean found = false;
				for(Long x : e)
					if(x == c) found = true;
				if (!found){
					ArrayList<Long> e2 = new ArrayList();
					e2.add(c);
					for(Long x : e) e2.add(Math.min(x, x^c));
					Collections.sort(e2, Collections.reverseOrder());
					e = e2;
				}
			}
		}
	}

	public static void main(String[] args) throws IOException {
		BufferedReader br = new BufferedReader( 
				new InputStreamReader(System.in));
		{
			StringTokenizer st = new StringTokenizer(br.readLine());
			n = Integer.parseInt(st.nextToken());
			m = Integer.parseInt(st.nextToken());
			q = Integer.parseInt(st.nextToken());
		}

		g = new ArrayList[n];
		for(int i = 0; i < n; ++i){
			g[i] = new ArrayList();
		}

		for(int i = 0; i < m; ++i){
			StringTokenizer st = new StringTokenizer(br.readLine());
			int u = Integer.parseInt(st.nextToken());
			int v = Integer.parseInt(st.nextToken());
			long w = Long.parseLong(st.nextToken());
			g[u-1].add(new Edge(v-1, w));
			g[v-1].add(new Edge(u-1, w));
		}

		d = new Long[n];
		d[0] = 0L;

		dfs(0);

		for(int qi = 0; qi < q; ++qi){
			StringTokenizer st = new StringTokenizer(br.readLine());
			int x = Integer.parseInt(st.nextToken()) - 1;
			int y = Integer.parseInt(st.nextToken()) - 1;
			long a = d[x] ^ d[y];
			for(Long w : e){
				a = Math.min(a, a^w);
			}
			System.out.println(a);
		}


	}
}
