import java.awt.geom.*;
import java.io.*;
import java.util.*;

public class Maarten {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new Maarten().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        String[] firstLine = reader.readLine().split(" ");
        int n = Integer.parseInt(firstLine[0]);
        int m = Integer.parseInt(firstLine[1]);

        double l = Double.parseDouble(reader.readLine());
        double original_l = l;

        List<Point2D.Double> res = new ArrayList<>();
        int x, y;
        outer:
        for (y = 0; y < m; y++) {
            for (x = 0; x <= n; x += n) {
                if (y * n + y * hypot(n, 1) + x + hypot(n - x, m - y) > original_l)
                    break outer;
                res.add(new Point2D.Double(x, y));
                if (x != 0 || y != 0)
                    l -= x == 0 ? hypot(n, 1) : n;
            }
        }

        double al = 0, ah = n, a = n / 2.;
        // Binary search for the in-between point to finish the cable
        if (res.size() % 2 == 0) { // Just moved from left to right, so move to left (and one up)
            while (!isclose(al, ah)) {
                a = (al + ah) / 2;
                if (hypot(a, 1) + hypot(a, m - y) < l)
                    al = a;
                else
                    ah = a;
            }
            res.add(new Point2D.Double(n - a, y));
        } else { // Just moved from right to left (and one up), so move to right
            while (!isclose(al, ah)) {
                a = (al + ah) / 2;
                if (a + hypot(n - a, m - y) < l)
                    al = a;
                else
                    ah = a;
            }
            res.add(new Point2D.Double(a, y));
        }

        System.out.println(res.size() + 1);
        for (Point2D.Double p : res) {
            System.out.println(p.x + " " + p.y);
        }
        System.out.println(n + " " + m);
    }

    double hypot(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    boolean isclose(double x, double y) {
        return Math.abs(x - y) < 1e-9;
    }
}
