import sys
import math

EPS = 1e-6

def get_zigzag():
    route = []

    if m % 2 == 0:
        loop = m + 1
    else:
        loop = m

    y = 0
    is_left = True
    for y in range(loop):
        if is_left:
            route.append((0,y))
            route.append((n,y))
        else:
            route.append((n,y))
            route.append((0,y))
        is_left = not is_left

    if m % 2 == 1:
        route.append((n,m))

    return route

def distance(start, end):
    start_x, start_y = start
    end_x, end_y = end

    return math.sqrt((end_x-start_x)**2 + (end_y-start_y)**2)

def total_distance(route):
    total_dist = 0
    for i in range(len(route) - 1):
        total_dist += distance(route[i], route[i+1])

    return total_dist


def interpolate(start, end, ell):
    start_x, start_y = start
    end_x, end_y = end

    if start_y != end_y:
        y = start_y
        a = ell - (n**2 + (m-y-ell)**2)/(-2*(m-y-ell))
        return (0, y+a)
    elif end_x > start_x:
        # towards goal
        y = start_y
        b = ell - ((m-y)**2 + (n-ell)**2)/(2*(ell - n))
        return (b, y)
    else:
        # away from goal
        y = start_y
        b = n - (ell**2 - (m-y)**2)/(2*ell)
        return (b, y)

def print_route(route):
    print(len(route))
    for x,y in route:
        print(x,y)

if __name__ == "__main__":
    input_nums = sys.stdin.readline().split()
    n = int(input_nums[0])
    m = int(input_nums[1])
    l = float(sys.stdin.readline())

    route = get_zigzag()


    total_dist = 0
    for i in range(len(route) - 1):
        start = route[i]
        end = route[i+1]

        dist = distance(start,end)

        if(total_dist + dist + distance(end,(n,m)) >= l - EPS):
            # interpolate
            #print(start, total_dist + distance(start, (n,m)))
            #print(end, total_dist + dist + distance(end, (n,m)))
            ell = l - total_dist
            coord = interpolate(start, end, ell)
            if(abs(coord[0] - start[0]) <= EPS and abs(coord[1] - start[1]) <= EPS):
                route = route[:i+1] + [(n,m)]
            else:
                route = route[:i+1] + [coord, (n,m)]
            
            print_route(route)
            sys.exit()
        else:
            total_dist += dist

    print_route(route)



