#include<cassert>
#include<cmath>
#include<iostream>
using namespace std;

typedef double FT;
#define L(x,y) sqrt((x)*(x) + (y)*(y))

const FT EPS = 1e-6;
int X, Y, np = 0; // number of points
FT x[200'002], y[200'002];

void add(FT px, FT py) {
	x[np] = px;
	y[np] = py;
	np++;
}

void search_last(FT len) {
	// do a binary search to adjust where to place the last point
	int lp = np-1;
	assert(lp >= 1);

	FT x0 = .5 * (X + x[lp-1]), y0 = .5 * (Y + y[lp-1]);
	// WA: FT x0 = x[lp-1], y0 = y[lp-1]; 
	FT dx = x[lp] - x0, dy = y[lp] - y0;

	assert(len < L(X - x[lp], Y - y[lp]));
	len += L(x[lp] - x[lp-1], y[lp] - y[lp-1]);
	assert(len >= L(X - x[lp-1], Y - y[lp-1]));

	FT lo = 0.0, hi = 1.0;

	// test lo
	assert(len >= L(x0 - x[lp-1], y0 - y[lp-1]) + L(X-x0, Y-y0));
	// test hi
	assert(len < L(x[lp] - x[lp-1], y[lp] - y[lp-1]) + L(X-x[lp], Y-y[lp]));

	for (int rep = 0; rep < 50; rep++) {
		FT mid = (lo + hi) * 0.5;

		FT mx = x0 + dx*mid, my = y0 + dy*mid;
		if (len < L(mx - x[lp-1], my - y[lp-1]) + L(X-mx, Y-my))
			hi = mid;
		else
			lo = mid;
	}

	x[lp] = x0 + dx * lo;
	y[lp] = y0 + dy * lo;
}

void run(FT &len) {
	FT lx = 0, ly = 0;
	for (int xp = 0; xp <= X; xp += 1) {
		cerr << "LENGTH LEFT: " << len << endl;
		FT fx = xp;
		for (int yl = 0, yr = Y; yl < yr; yl++, yr--) {
			add(fx, yl);
			len -= L(lx - fx, ly - yl);
			if (len < L(X - fx, Y - yl))
				return; // not enough rope left!
			lx = fx; ly = yl;
			fx += EPS;

			add(fx, yr);
			len -= L(lx - fx, ly - yr);
			if (len < L(X - fx, Y - yr))
				return; // not enough rope left!
			lx = fx; ly = yr;
			fx += EPS;
		}
	}
}

int main() {
	(cout << fixed).precision(8);
	FT len;
	cin >> X >> Y >> len;

	bool swp = X > Y;
	if (swp) swap(X, Y);
	// X <= Y

	run(len);
	search_last(len);
	add(X, Y);

	cout << np << endl;
	for (int i=0; i < np; i++) {
		cout << (swp ? y[i] : x[i]) << " " << (swp ? x[i] : y[i]) << endl;
	}
	return 0;
}
