#include<cmath>
#include<iostream>
using namespace std;

typedef float FT;
#define L(x,y) sqrt((x)*(x) + (y)*(y))

int X, Y, np = 0; // number of points
FT x[202], y[202];

void add(FT px, FT py) {
	x[np] = px;
	y[np] = py;
	np++;
}

void search1(int xp, FT len) {
	FT lo = 0.0, hi = 0.5;
	for (int rep = 0; rep < 50; rep++) {
		FT mid = (lo + hi) * 0.5;
		
		FT mx = xp + mid * (X - xp), my = Y - mid * Y;
		if (L(mx-xp, my-0) + L(X-mx, Y-my) < len)
			hi = mid;
		else
			lo = mid;
	}

	FT mid = (lo + hi) * 0.5, mx = xp + mid * (X - xp), my = Y - mid * Y;
	add(mx, my);
}

void search2(int xp, FT len) {
	FT lo = 0.0, hi = 1;
	for (int rep = 0; rep < 50; rep++) {
		FT mid = (lo + hi) * 0.5;
		
		FT my = mid * Y;
		if (L(1, Y-my) + L(X-xp, Y-my) < len)
			hi = mid;
		else
			lo = mid;
	}

	FT mid = (lo + hi) * 0.5, my = mid * Y;
	add(xp, my);
}

int main() {
	FT len;
	cin >> X >> Y >> len;

	add(0, 0);
	int xp = 0;
	while (true) {
		if (L(0, Y) + L(X-xp, 0) > len) {
			// binary search this point
			search1(xp, len);
			break;
		}

		add(xp, Y);
		len -= L(0, Y);

		xp++;

		if (L(1, -Y) + L(X-xp, Y) > len) {
			search2(xp, len);
			break;
		}

		add(xp, 0);
		len -= L(1, -Y);
	}

	add(X, Y);

	cout << np << endl;
	for (int i=0; i < np; i++)
		cout << x[i] << " " << y[i] << endl;
	return 0;
}
