#include <iostream>
#include <vector>
#include <math.h>
#include <iomanip>

using namespace std;

int main() {
    int n, m;
    double l;
    cin >> n >> m >> l;
    double delta = 0.0000001;
    if (abs(sqrt(n * n + m * m) - l) <= delta) {
        cout << "2" << endl;
        cout << "0 0" << endl;
        cout << n << " " << m << endl;
        return 0;
    }

    if (l >= n + m) {
        // Zigzag case
        vector<pair<double, double>> points;
        points.push_back(make_pair(0, 0));

        int cy = 0;

        // First, go all the way right. We know it will fit
        points.push_back(make_pair(n, cy));
        l -= n;
        l -= m;

        // Now keep going left and right until we can't anymore
        while (l > 2 * n) {
            points.push_back(make_pair(n, cy + 1));
            points.push_back(make_pair(0, cy + 1));
            points.push_back(make_pair(0, cy + 2));
            points.push_back(make_pair(n, cy + 2));
            cy += 2;
            l -= 2 * n;
        }

        if (l > 0) {
            // Now do the final part
            points.push_back(make_pair(n, cy + 1));
            points.push_back(make_pair(n - (l / 2.0), cy + 1));
            points.push_back(make_pair(n - (l / 2.0), cy + 2));
            points.push_back(make_pair(n, cy + 2));
        }
        points.push_back(make_pair(n, m));

        cout << points.size() << endl;
        for (auto p : points) { 
            cout << setprecision(9) << p.first << " " << p.second << endl;
        }
    } else {
        // Binary search for the number we want
        double low = 0;
        double high = n;
        double q;
        // Just do it 100 times. I'm lazy
        for (int i = 0; i < 100; i++) {
            q = (low + high) / 2;
            double a = q + sqrt(m * m + (n - q) * (n - q));
            if (a > l) {
                high = q;
            } else if (a < l) {
                low = q;
            }
        }

        // Now we assume m is correct
        cout << 3 << endl;
        cout << "0 0" << endl;
        cout << q << " 0" << endl;
        cout << n << " " << m << endl;
    }

    return 0;
}
