#!/usr/bin/env python3

from math import sqrt

n, m = map(int, input().split())
l = float(input())


def dist(p, q):
    return sqrt((p[0] - q[0]) ** 2 + (p[1] - q[1]) ** 2)


p = (0, 0)
t = (n, m)
ans = [p]

while l >= dist(p, t):
    x, y = p
    if x == 0:
        if y % 2 == 0:
            q = (n, y)
        else:
            q = (0, y + 1)
    elif x == n:
        if y % 2 == 0:
            q = (n, y + 1)
        else:
            q = (0, y)
    else:
        assert False

    ll = dist(p, q)
    if l - ll >= dist(q, t):
        l -= ll
        p = q
        ans.append(p)
    else:
        # Binary search the point s on pq such that d(p, s) + d(s, t) == l
        # 30 steps should give plenty precision.
        al, ah = 0, 1
        for _ in range(30):
            am = (al + ah) / 2
            s = (am * q[0] + (1 - am) * p[0], am * q[1] + (1 - am) * p[1])
            if dist(p, s) + dist(s, t) > l:
                ah = am
            else:
                al = am
        p = s
        ans.append(p)
        ans.append(t)
        break
print(len(ans))
for p in ans:
    print(*p)
