#!/usr/bin/env python3
#
# Testing tool for the Evolutionary Excerpt problem
#
# NOTE: This tool does not verify the correctness of your answer.
# It will only print the length of your answer.
#
# Usage:
#
#   python3 testing_tool.py -f inputfile <program invocation>
#
#
# Use the -f parameter to specify the input file, e.g. 1.in.
# The input file should contain one line, containing the value of n.
#
#
# You can compile and run your solution as follows.
# - You may have to replace "python3" by just "python".
# - On Windows, you may have to to replace '/' by '\'.

# C++:
#   g++ solution.cpp
#   python3 testing_tool.py -f 1.in ./a.out

# Java
#   javac solution.java
#   python3 testing_tool.py -f 1.in java solution

# Python3
#   python3 testing_tool.py -f 1.in python3 ./solution.py


# The tool is provided as-is, and you should feel free to make
# whatever alterations or augmentations you like to it.
#
# The tool attempts to detect and report common errors, but it is not an
# exhaustive test. It is not guaranteed that a program that passes this testing
# tool will be accepted.


import argparse
import random
import subprocess
import sys
import traceback


def write(p, line, trim=False):
    assert p.poll() is None, "Program terminated early"
    printline = line
    if trim and len(printline) > 1000:
        printline = printline[:1000] + " ..."
    print("Write: {}".format(printline), flush=True)
    p.stdin.write("{}\n".format(line))
    p.stdin.flush()


def read(p, trim=False):
    assert p.poll() is None, "Program terminated early"
    line = p.stdout.readline().strip()
    assert line != "", "Read empty line or closed output pipe"
    printline = line
    if trim and len(printline) > 1000:
        printline = printline[:1000] + " ..."
    print("Read: {}".format(printline), flush=True)
    return line


parser = argparse.ArgumentParser(description="Testing tool for problem Evolutionary Excerpt.")
parser.add_argument("-f", dest="inputfile", metavar="inputfile", default=None, type=argparse.FileType("r"),
                    required=True, help="The input file to use.")
parser.add_argument("program", nargs="+", help="Invocation of your solution")

args = parser.parse_args()

with args.inputfile as f:
    lines = f.readlines()
    n = int(lines[0])

with subprocess.Popen(" ".join(args.program), shell=True, stdout=subprocess.PIPE, stdin=subprocess.PIPE,
                      universal_newlines=True) as p:
    try:
        write(p, "{}".format(n))

        sequence_A = random.choices("ACTG", k=n)
        sequence_B = random.choices("ACTG", k=n)
        write(p, "".join(sequence_A), trim=True)
        write(p, "".join(sequence_B), trim=True)

        answer = read(p, trim=True)
        sys.stdout.write("\nYour answer has length: {}\n".format(len(answer)))
        assert len(answer) >= n / 2, "Your subsequence is not long enough"
        sys.stdout.write("\nSuccess.\n")

        assert p.stdout.readline() == "", "Your submission printed extra data after finding a solution."
        assert p.wait() == 0, "Your submission did not exit cleanly after finishing."

    except:
        print()
        traceback.print_exc()
        print()
        try:
            p.wait(timeout=2)
        except subprocess.TimeoutExpired:
            print("Killing your submission after 2 second timeout.")
            p.kill()
    finally:
        sys.stdout.flush()
        sys.stderr.flush()
        sys.stdout.write("Exit code: {}\n".format(p.wait()))
        sys.stdout.flush()
