import java.io.*;
import java.util.*;
import java.awt.*;

public class ludo {
	public static void main(String[] args) throws IOException {
		if (run()) System.out.println("possible");
		else System.out.println("impossible");
	}

	public static boolean run() throws IOException {
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));	
		int n = Integer.valueOf(in.readLine());
		if (n % 2 == 1) return false;
		int[] xs = new int[n], ys = new int[n];
		long sumx = 0, sumy = 0;
		for (int i=0; i<n; i++) {
			String[] parts = in.readLine().split(" ");
			xs[i] = Integer.valueOf(parts[0]);
			ys[i] = Integer.valueOf(parts[1]);
			sumx += xs[i];
			sumy += ys[i];
		}

		if (sumx % (n/2) != 0 || sumy % (n/2) != 0) return false;
		int cx = (int) (sumx / (n/2)), cy = (int) (sumy / (n/2));
		Point[] before = new Point[n], after = new Point[n];	

		for (int i=0; i<n; i++) {
			before[i] = new Point(xs[i], ys[i]);
			after[i] = new Point(cx - xs[i], cy - ys[i]);
		}

		Arrays.sort(before, (Point a, Point b) -> { return a.x != b.x ? a.x - b.x : a.y - b.y; });
		Arrays.sort(after,  (Point a, Point b) -> { return a.x != b.x ? a.x - b.x : a.y - b.y; });

		for (int i=0; i<n; i++)
			if (before[i].x != after[i].x || before[i].y != after[i].y)
				return false;

		int centres = 0;
		for (int i=0; i<n; i++)
			if (2*xs[i] == cx && 2*ys[i] == cy) centres++;
		return centres % 2 == 0;
	}
}
