import java.io.*;
import java.util.*;
import java.text.*;

class Reinier {
	static Scanner sc;

	static ArrayList<ArrayList<Integer>> adj, adj2;
	static long[][] d;

	static void run() {
		int n = sc.nextInt();
		int m = sc.nextInt();
		int c = sc.nextInt() - 1;
		int r = sc.nextInt() - 1;
		
		adj = new ArrayList<>();
		for (int i = 0; i < n; i++) {
			adj.add(new ArrayList<>());
		}
		d = new long[n][n];
		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) {
				d[i][j] = 1L<<61;
			}
			d[i][i] = 0;
		}

		// Read input
		for (int i = 0; i < m; i++) {
			int a = sc.nextInt() - 1;
			int b = sc.nextInt() - 1;
			long l = sc.nextLong();
			d[a][b] = l;
			d[b][a] = l;
			adj.get(a).add(b);
			adj.get(b).add(a);
		}

		// APSP
		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) {
				for (int k = 0; k < n; k++) {
					d[j][k] = Math.min(d[j][k], d[j][i]+d[i][k]);
				}
			}
		}

		// Compute new graph
		adj2 = new ArrayList<>();
		for (int i = 0; i < n; i++) {
			adj2.add(new ArrayList<>());
		}
		for (int i = 0; i < n; i++) {
			if (adj.get(i).size() <= 1) continue;
			long maxDist = 0;
			for (int j = 0; j < n; j++) {
				if (d[i][j] == maxDist) {
					adj2.get(i).add(j);
				} else if (d[i][j] > maxDist) {
					adj2.set(i, new ArrayList<>());
					adj2.get(i).add(j);
					maxDist = d[i][j];
				}
			}
		}

		// Perform first approach
		int approachDirection = -1;
		for (int i : adj.get(r)) {
			if (d[c][r] == d[c][i] + d[i][r]) {
				approachDirection = i;
			}
		}
		boolean[] reachable = new boolean[n];
		getReachable(r, approachDirection, reachable);
		ArrayList<Integer> posDest = new ArrayList<>();
		long maxDist = 0;
		for (int i = 0; i < n; i++) {
			if (reachable[i] && d[r][i] == maxDist) {
				posDest.add(i);
			} else if (reachable[i] && d[r][i] > maxDist) {
				posDest = new ArrayList<>();
				posDest.add(i);
				maxDist = d[r][i];
			}
		}

		// Check for reachable cycles in new graph
		int[] dfsState = new int[n];
		long[] R = new long[n];
		long res = d[c][r];
		boolean pos = true;
		for (int i : posDest) {
			long partRes = dfs(i, dfsState, R);
			if (partRes < 0) {
				pos = false;
			} else {
				res = Math.max(res, partRes + d[c][r] + d[r][i]);
			}
		}
		if (pos) {
			System.out.println(res);
		} else {
			System.out.println("impossible");
		}
	}

	static void getReachable(int i, int c, boolean[] reachable) {
		if (reachable[i]) return;
		reachable[i] = true;
		for (int j : adj.get(i)) {
			if (j == c) continue;
			getReachable(j, -1, reachable);
		}
	}

	static long dfs(int i, int[] dfsState, long[] R) {
		if (dfsState[i] == 2) return R[i];
		else if (dfsState[i] == 1) return -1;
		dfsState[i] = 1;
		for (int j : adj2.get(i)) {
			long r = dfs(j, dfsState, R);
			if (r < 0) return -1;
			else R[i] = Math.max(R[i], r + d[i][j]);
		}
		dfsState[i] = 2;
		return R[i];
	}

	public static void main(String args[]) {
		sc = new Scanner(System.in);
		run();
	}
}
