#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
typedef long double ld;
typedef pair<ll, ll> ii;
typedef vector<ll> vi;
typedef vector<vi> vvi;
typedef vector<ii> vii;
typedef vector<vii> vvii;

#define x first
#define y second
#define pb push_back
#define eb emplace_back
#define all(v) (v).begin(), (v).end()

struct graphData {
	ll Vsize = 0, Esize = 0;
	ll maxDepth = 0;
};

vvi adj;
vvi adj2;
vvi d;

void getReachable(ll i, ll c, vector<bool>& reachable) {
	if (reachable[i]) return;
	reachable[i] = true;
	for (ll j : adj[i]) {
		if (j == c) continue;
		getReachable(j, -1, reachable);
	}
}

ll dfs(ll i, vi& dfsState, vi& R, graphData& data, ll depth) {
	if (dfsState[i] == 2) return R[i];
	else if (dfsState[i] == 1) return -1;
	data.Vsize++;
	data.maxDepth = max(data.maxDepth, depth);
	dfsState[i] = 1;
	bool hasCycle = false;
	for (ll j : adj2[i]) {
		data.Esize++;
		ll r = dfs(j, dfsState, R, data, depth+1);
		if (r < 0) hasCycle = true;
		else R[i] = max(R[i], r + d[i][j]);
	}
	dfsState[i] = 2;
	if (hasCycle) return -1;
	else return R[i];
}

void run() {
	ll n, m, c, r;
	cin >> n >> m >> c >> r;
	c--; r--;
	adj = vvi(n);
	d = vvi(n, vi(n, 1ll<<61));
	for (ll i = 0; i < n; i++) {
		d[i][i] = 0;
	}
	
	// Read input
	for (ll i = 0; i < m; i++) {
		ll a, b, l;
		cin >> a >> b >> l;
		a--; b--;
		d[a][b] = l;
		d[b][a] = l;
		adj[a].pb(b);
		adj[b].pb(a);
	}
	
	// APSP
	for (ll i = 0; i < n; i++) {
		for (ll j = 0; j < n; j++) {
			for (ll k = 0; k < n; k++) {
				d[j][k] = min(d[j][k], d[j][i]+d[i][k]);
			}
		}
	}
	
	// Compute new graph
	adj2 = vvi(n);
	for (ll i = 0; i < n; i++) {
		if (adj[i].size() <= 1) continue;
		ll maxDist = 0;
		for (ll j = 0; j < n; j++) {
			if (d[i][j] == maxDist) {
				adj2[i].pb(j);
			} else if (d[i][j] > maxDist) {
				adj2[i] = vi{j};
				maxDist = d[i][j];
			}
		}
	}

	// Perform first approach
	ll approachDirection = -1;
	for (ll i : adj[r]) {
		if (d[c][r] == d[c][i] + d[i][r]) {
			approachDirection = i;
		}
	}
	vector<bool> reachable(n, false);
	getReachable(r, approachDirection, reachable);
	vi posDest; ll maxDist = 0;
	bool firstFlightMaxDist = true;
	for (ll i = 0; i < n; i++) {
		if (d[r][i] >= maxDist && !reachable[i]) {
			firstFlightMaxDist = false;
		}
		if (reachable[i] && d[r][i] == maxDist) {
			posDest.pb(i);
		} else if (reachable[i] && d[r][i] > maxDist) {
			firstFlightMaxDist = true;
			posDest = vi{i};
			maxDist = d[r][i];
		}
	}
	cerr << "First flight different: ";
	if (firstFlightMaxDist) {
		cerr << "NO" << endl;
	} else {
		cerr << "YES" << endl;
	}

	// Check for reachable cycles in new graph
	graphData data;
	vi dfsState(n, 0), R(n, 0);
	ll res = d[c][r];
	bool pos = true;
	for (ll i : posDest) {
		ll partRes = dfs(i, dfsState, R, data, 0);
		if (partRes < 0) {
			pos = false;
		} else {
			res = max(res, partRes + d[c][r] + d[r][i]);
		}
	}
	cerr << "New graph: |V| = " << data.Vsize << ", |E| = " << data.Esize << ", " << "maxDepth = " << data.maxDepth << endl;
	if (pos) {
		cout << res << endl;
	} else {
		cout << "impossible" << endl;
	}
}

signed main() {
    ios_base::sync_with_stdio(false); cin.tie(0);
    run();
    return 0;
}
