#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
typedef long double ld;
typedef pair<ll, ll> ii;
typedef vector<ll> vi;
typedef vector<vi> vvi;
typedef vector<ii> vii;
typedef vector<vii> vvii;

#define x first
#define y second
#define pb push_back
#define eb emplace_back
#define all(v) (v).begin(), (v).end()

ll n;
vvi adj;
vvi d;
vi res;

void getReachable(ll i, ll c, vector<bool>& reachable) {
	if (reachable[i]) return;
	reachable[i] = true;
	for (ll j : adj[i]) {
		if (j == c) continue;
		getReachable(j, -1, reachable);
	}
}

vi getAdj(ll c, ll r) {
	ll approachDirection = -1;
	for (ll i : adj[r]) {
		if (d[c][r] == d[c][i] + d[i][r]) {
			approachDirection = i;
		}
	}
	vector<bool> reachable(n, false);
	getReachable(r, approachDirection, reachable);
	vi posDest; ll maxDist = 0;
	for (ll i = 0; i < n; i++) {
		if (reachable[i] && d[r][i] == maxDist && i != r) {
			posDest.pb(i);
		} else if (reachable[i] && d[r][i] > maxDist) {
			posDest = vi{i};
			maxDist = d[r][i];
		}
	}
	return posDest;
}

ll dfs(ll c, ll r) {
	if (res[r] >= -1) return res[r];
	res[r] = -1;
	ll rn = 0;
	for (ll i : getAdj(c, r)) {
		ll dr = d[r][i] + dfs(r, i);
		if (dr-d[r][i] < 0) return -1;
		rn = max(rn, dr);
	}
	res[r] = rn;
	return res[r];
}

void run() {
	ll m, c, r;
	cin >> n >> m >> c >> r;
	c--; r--;
	adj = vvi(n);
	d = vvi(n, vi(n, 1ll<<61));
	res = vi(n, -2);
	for (ll i = 0; i < n; i++) {
		d[i][i] = 0;
	}
	
	// Read input
	for (ll i = 0; i < m; i++) {
		ll a, b, l;
		cin >> a >> b >> l;
		a--; b--;
		d[a][b] = l;
		d[b][a] = l;
		adj[a].pb(b);
		adj[b].pb(a);
	}
	
	// APSP
	for (ll i = 0; i < n; i++) {
		for (ll j = 0; j < n; j++) {
			for (ll k = 0; k < n; k++) {
				d[j][k] = min(d[j][k], d[j][i]+d[i][k]);
			}
		}
	}

	ll ans = d[c][r] + dfs(c, r);
	if (ans-d[c][r] < 0) {
		cout << "impossible" << endl;
	} else {
		cout << ans << endl;
	}
}

signed main() {
    ios_base::sync_with_stdio(false); cin.tie(0);
    run();
    return 0;
}
