import java.io.*;
import java.util.*;

public class MaartenIterative {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new MaartenIterative().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        String[] firstLine = reader.readLine().split(" ");
        int h = Integer.parseInt(firstLine[0]);
        int w = Integer.parseInt(firstLine[1]);

        // kangaroo = [[x for x, c in enumerate(input()) if c == "#"] for _ in range(h)]
        int[][] kangaroo = new int[h][];
        for (int y = 0; y < h; y++) {
            String s = reader.readLine();
            int count = 0;
            for (char c : s.toCharArray()) {
                if (c == '#')
                    count++;
            }
            kangaroo[y] = new int[count];
            int k = 0;
            for (int i = 0; i < s.length(); i++) {
                if (s.charAt(i) == '#')
                    kangaroo[y][k++] = i;
            }
        }

        List<List<Integer>> positionsList = new ArrayList<>();
        List<List<Integer>> positionsSublist = new ArrayList<>();
        positionsList.add(Collections.emptyList());
        for (int x = 0; x < w - 1; x++) {
            positionsList.add(Collections.singletonList(x));
            positionsSublist.add(Collections.singletonList(x));
        }
        for (int cans = 0; cans <= w / 2; cans++) {
            List<List<Integer>> positionsSublistNew = new ArrayList<>();
            for (List<Integer> previous : positionsSublist) {
                for (int x = previous.get(previous.size() - 1) + 2; x < w - 1; x++) {
                    List<Integer> positions = new ArrayList<>(previous);
                    positions.add(x);
                    positionsSublistNew.add(positions);
                }
            }
            positionsSublist = positionsSublistNew;
            positionsList.addAll(positionsSublist);
        }

        int[][] memo = new int[h + 2][positionsList.size()];
        for (int y = 3; y < h + 2; y += 2) {
            for (int i = 0; i < positionsList.size(); i++) {
                List<Integer> positions = positionsList.get(i);
                int val = Integer.MAX_VALUE / 2;
                next:
                for (int j = 0; j < positionsList.size(); j++) {
                    List<Integer> newPos = positionsList.get(j);
                    // Calculate whether `new_pos` covers the kangaroo at position `y - 2`
                    // if (not (1 <= y - 2 < len(kangaroo)) or
                    // all(all(x in new_pos or x - 1 in new_pos for x in kangaroo[y]) for y in range(y - 3, y - 1)))
                    if (3 <= y && y - 2 < kangaroo.length) {
                        for (int y1 = y - 3; y1 < y - 1; y1++) {
                            for (int x : kangaroo[y1]) {
                                if (!newPos.contains(x - 1) && !newPos.contains(x))
                                    continue next;
                            }
                        }
                    }
                    // Calculate whether `new_pos` is allowed to stack on `positions`
                    // and all(any(x in positions for x in range(x - 1, x + 2)) for x in new_pos))
                    for (Integer x : newPos) {
                        if (!positions.contains(x - 1) && !positions.contains(x) && !positions.contains(x + 1))
                            continue next;
                    }
                    val = Integer.min(val, memo[y - 2][j] + newPos.size());
                }
                memo[y][i] = val;
            }
        }

        System.out.println(memo[h + 1][positionsList.size() - 1]);
    }
}
