#include<iostream>
#include<cassert>
#include<climits>
using namespace std;

// const int fib9 = 34; // max{m} = 8
const int fib9 = 10597; // F_{17} since m <= 16.
int n, m, a[100] = {};

int pc[fib9], cover[fib9], DP[2][fib9];
bool trans[fib9][fib9];

int main() {
	cin >> n >> m;
	for (int i = n-1; i >= 0; i--) {
		string S;
		cin >> S;
		for (int j = 0; j < m; j++)
			if (S[j] == '#')
				a[i] |= (1<<j);
	}
 
	// compress even and odd layers
	for (int i=0; 2*i < n; i++)
		a[i] = a[2*i] | a[2*i+1]; // bitwise OR

	int nlast = 1, ncur = 1;
	cover[0] = pc[0] = 0;
	for (int i = 2; i <= m; i++) {
		int num_next = nlast + ncur;

		for (int j = 0; j < nlast; j++) {
			cover[ncur + j] = cover[j] | (3<<(i-2));
			pc[ncur + j] = pc[j] + 1;
		}

		nlast = ncur;
		ncur = num_next;
	}

	for (int down = 0; down < ncur; down++)
		for (int up = 0; up < ncur; up++) {
			trans[down][up] = true;
			for (int i = 0; i < m; i++)
				if ((cover[up] >> i) & 1) {
					assert(cover[up] >> (i+1) & 1);
					if (((cover[down] >> i) & 3) == 0)
						trans[down][up] = false;
					++i;
				}
		}

	for (int i=0; i < ncur; i++)
		DP[0][i] = (a[0] & ~cover[i]) ? INT_MAX : pc[i];

	for (int row = 1; 2*row < n; row++) {
		for (int j=0; j < ncur; j++) {
			DP[1][j] = INT_MAX;
			if (a[row] & ~cover[j])
				continue;
			for (int i=0; i < ncur; i++) {
				if (DP[0][i] != INT_MAX && trans[i][j])
					DP[1][j] = min(DP[1][j], DP[0][i] + pc[j]);
			}
		}

		for (int j=0; j < ncur; j++)
			DP[0][j] = DP[1][j];
	}

	int result = INT_MAX;
	for (int j=0; j < ncur; j++)
		result = min(result, DP[0][j]);

	cout << result << endl;
	return 0;
}
