#!/usr/bin/env python3

n, m = map(int, input().split())

# NOTE: We reverse layers so that the bottom of the cangaroo comes first.
b = list(reversed([input() for _ in range(n)]))

states = []
for i in range(1 << (m - 1)):
    ok = True
    cnt = 0
    for j in range(m - 1):
        if i & (1 << j):
            cnt += 1
        if (i & (1 << j)) and (i & (1 << (j + 1))):
            ok = False
            break
    if ok:
        states.append((i, cnt))

# Can s2 go on top of s1
def supports(s1, s2):
    return s2 == (s2 & ((s1 << 1) | s1 | (s1 >> 1)))


def covers(s, layer):
    l = 0
    for i in range(m):
        if b[layer][i] == "#" or b[layer + 1][i] == "#":
            l |= 1 << i
    return (l & (s | (s << 1))) == l


# inf when impossible
inf = 10 ** 9
cost = [0] * len(states)

for l in range(0, n, 2):
    newcost = [inf] * len(states)

    for i, (s1, _) in enumerate(states):
        if cost[i] == inf:
            continue
        for j, (s2, c) in enumerate(states):
            if not supports(s1, s2):
                continue
            if not covers(s2, l):
                continue
            newcost[j] = min(newcost[j], cost[i] + c)

    cost = newcost

print(min(cost))
