#include "validation.h"

// For FIXED OUTPUT PROBLEMS:
// This program will be called as
// output_validator input < ans
//
// You should verify the grammar of the answer file.
// See input_validator.cpp for information on how to use the Validator class.
// Furthermore you should check simple properties of the answer.

// For DYNAMIC OUTPUT PROBLEMS:
// This program will be called as
// output_validator input answer < team_output
//
// Please check the grammar of the team output using the Validator class.
// See input_validator.cpp for information on how to use the Validator class.
// You should also check the validity of the answer here.
// For example, check that a tree printed by the team is a tree indeed.

// For INTERACTIVE PROBLEMS:
// Write your output validator as usual, but make sure to flush all standard
// output. Call `v.set_WA_handler(lambda)` to gracefully handle failures when
// parsing team output. You could e.g. send a '-1' to the submission to tell it
// to stop running.

// This validator evaluates up to 100 queries from the team output.

typedef long long ll;

const ll M = 1000000007;

// eval, assumes 0<=values[i] < M
ll evalops(std::string& ops, std::vector<ll>& values) {
	int64_t sm = values[0];
	for(int i = 0; i < ops.size(); i++) {
		if(ops[i] == '+') sm += values[i + 1];
		if(ops[i] == 'x') sm *= values[i + 1];
		sm %= M;
	}
	return sm;
}

int main(int argc, char** argv) {
	// The testcase .in file.
	std::ifstream in(argv[1]);
	OutputValidator v(argc, argv);

	ll n;
	in >> n;
	std::cout << n << std::endl;
	std::string ops;
	in >> ops;

	int maxq    = 275;
	int queries = 0;
	while(true) {
		std::string cmd = v.read_string("cmd", 1, 1, "?!");
		if(cmd == "?") {
			queries++;
			v.check(queries <= maxq, "Exceeded max queries.");
			v.space();
			std::vector<ll> a = v.read_integers("a", n + 1, 0, M - 1);
			ll result         = evalops(ops, a);
			std::cout << result << std::endl;
		}

		if(cmd == "!") {
			v.space();
			std::string ans = v.read_string("query", n, n, "+x");
			v.check(ops == ans, "Incorrect answer! Found ", ans, " expected ", ops);
			std::cerr << "Queries: " << queries << std::endl;
			return 0;
		}
	}
}
