import java.io.*;
import java.util.*;

public class MaartenGyrating {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new MaartenGyrating().run(new Scanner(reader));
        }
    }

    long MOD = 1_000_000_007;
    int STEP = 16;

    // def permutations(i, base):
    //     if i <= 0: return [base]
    //     prev = permutations(i - 1, base)
    //     return [*((v + (STEP + 1)) % MOD for v in prev), *((v * (STEP + 1)) % MOD for v in prev)]
    long[] permutations(int i, long base) {
        if (i <= 0) {
            return new long[]{base};
        }
        long[] prev = permutations(i - 1, base);
        long[] res = new long[prev.length * 2];
        int k = 0;
        for (long v : prev) {
            res[k++] = (v + (STEP + 1)) % MOD;
        }
        for (long v : prev) {
            res[k++] = (v * (STEP + 1)) % MOD;
        }
        return res;
    }

    // mem = {v: i for i, v in enumerate(permutations(s, b))}
    Map<Long, Integer> build_mem(int s, int b) {
        long[] permutations = permutations(s, b);
        Map<Long, Integer> mem = new HashMap<>(permutations.length);
        for (int i = 0; i < permutations.length; i++) {
            mem.put(permutations[i], i);
        }
        return mem;
    }

    public void run(Scanner sc) throws IOException {
        int n = sc.nextInt();
        char[] ops = new char[n];
        Map<Long, Integer> mem = build_mem(STEP, 0);

        for (int i = 0; i < n; i += STEP) {
            boolean is_last = i >= n - STEP && n % STEP != 0;
            int remaining = n + 1 - i;
            int s = Integer.min(remaining, STEP);
            if (is_last) mem = build_mem(s - 1, STEP + 1);

            // print(" ".join(("?", *["0"] * (remaining - STEP), *[str(STEP + 1)] * s, *ops)))
            StringBuilder query = new StringBuilder("?");
            query.append(" 0".repeat(Math.max(0, remaining - STEP)));
            query.append((" " + (STEP + 1)).repeat(s));
            for (int j = n - i; j < n; j++) {
                query.append(" ").append(ops[j]);
            }
            System.out.println(query);

            // ops = [*reversed(f"{mem[int(input())]:#0{s + 2}b}"[2 + is_last:]), *ops]
            String binary = String.format("%" + s + "s", Integer.toBinaryString(mem.get(sc.nextLong()))).replace(' ', '0');
            if (is_last) binary = binary.substring(1);
            for (int j = 0; j < binary.length(); j++) {
                ops[n - i - 1 - j] = binary.charAt(j);
            }
        }

        // print("! " + "".join(ops).translate(str.maketrans("01", "+x")))
        StringBuilder ans = new StringBuilder("! ");
        for (char op : ops) {
            ans.append(op == '0' ? '+' : 'x');
        }
        System.out.println(ans);
    }
}
