#!/usr/bin/env python3

import random

random.seed(0)
n = int(input())
M = 10 ** 9 + 7

# Find a set of at least integers such that each combination of + and * between
# them gives a unique answer.
k = 15


def eval(vals, m, k):
    val = 0
    for i, v in zip(range(k), vals):
        if m & (1 << i):
            val *= v
        else:
            val += v
        val %= M
    return val


def make_dict(vals, k):
    d = dict()
    ok = True
    for m in range(2 ** k):
        v = eval(vals, m, k)
        if v in d:
            return False
        d[v] = m
    return d

t=0
while True:
    t += 1
    vals = random.choices(range(M), k=k)

    d0 = make_dict(vals, k)
    d1 = make_dict(vals, n % k)
    if d0 is not False and d1 is not False:
        break


rops = []
plusses = 0

for i in range((n - 1) // k + 1):
    right = i * k
    cur = min(n - right, k)
    left = n + 1 - cur - right

    qs = [0] * left + vals[:cur] + [1] * right
    print("?", *qs, flush=True)
    v = int(input()) - plusses
    d = d0 if cur == k else d1
    assert v in d
    m = d[v]
    for i in reversed(range(cur)):
        op = "x" if m & (1 << i) else "+"
        rops.append(op)
        if op == "+":
            plusses += 1

print("! ", *reversed(rops[:n]), sep="")
