#!/usr/bin/env python3

import random

n = int(input())

M = 10 ** 9 + 7

# Find a set of at least integers such that each combination of + and * between
# them gives a unique answer.
k = 16
cs = []
t = 0


def eval(val, vals, m, k):
    for i, v in zip(range(k), vals):
        if m & (1 << i):
            val *= v
        else:
            val += v
        val %= M
    return val


while True:
    t += 1
    vals = random.choices(range(M), k=k)

    d0 = dict()
    d1 = dict()
    ok = True
    for m in range(2 ** k):
        v = eval(0, vals, m, k)
        if v in d0:
            ok = False
            break
        d0[v] = m

    if not ok:
        continue

    kk = n % k

    for m in range(2 ** kk):
        v = eval(0, vals, m, kk)
        if v in d1:
            ok = False
            break
        d1[v] = m

    if ok:
        break


rops = []
plusses = 0

for i in range((n - 1) // k + 1):
    right = i * k
    cur = min(n - right, k)
    left = n + 1 - cur - right

    qs = [0] * left + vals[:cur] + [1] * right
    print("?", *qs, flush=True)
    v = int(input())
    v -= plusses
    d = d0 if cur == k else d1
    assert v in d
    m = d[v]
    for i in reversed(range(cur)):
        op = "x" if m & (1 << i) else "+"
        rops.append(op)
        if op == "+":
            plusses += 1

print("! ", *reversed(rops[:n]), sep="")
