#include "validation.h"

// For FIXED OUTPUT PROBLEMS:
// This program will be called as
// output_validator input < ans
//
// You should verify the grammar of the answer file.
// See input_validator.cpp for information on how to use the Validator class.
// Furthermore you should check simple properties of the answer.

// For DYNAMIC OUTPUT PROBLEMS:
// This program will be called as
// output_validator input answer < team_output
//
// Please check the grammar of the team output using the Validator class.
// See input_validator.cpp for information on how to use the Validator class.
// You should also check the validity of the answer here.
// For example, check that a tree printed by the team is a tree indeed.

// For INTERACTIVE PROBLEMS:
// Write your output validator as usual, but make sure to flush all standard
// output. Call `v.set_WA_handler(lambda)` to gracefully handle failures when
// parsing team output. You could e.g. send a '-1' to the submission to tell it
// to stop running.


// Check whether there are four points in the plane present, with the right
// distance from the center in the assignment and the right distance from each
// other.

using namespace std;

int main(int argc, char **argv) {
	// Set up the input and answer streams.
	std::ifstream in(argv[1]);
	// std::ifstream ans(argv[2]); // Only for custom checker.
	OutputValidator v(argc, argv);

    long long x, y, r;
    in >> x >> y >> r;

    vector<pair<long long, long long>> coordinates(4);
    for(int i = 0; i < 4; i++) {
        coordinates[i].first = v.read_integer("xi", -3000000000LL, 3000000000LL);
        v.space();
        coordinates[i].second = v.read_integer("yi", -3000000000LL, 3000000000LL);
        v.newline();
    }

    for(int i = 0; i < 4; i++) {
        auto p = coordinates[i];
        long long dist_squared = (x-p.first)*(x-p.first) + (y-p.second)*(y-p.second);
        v.check(dist_squared == 2*r*r, "Corners are not the right distance from the center.");
    }

    for(int i = 0; i < 4; i++) {
        auto p = coordinates[i];
        auto q = coordinates[(i+1)%4];
        long long dist_squared = (p.first-q.first)*(p.first-q.first)
            + (p.second-q.second)*(p.second-q.second);
        v.check(dist_squared == 4*r*r, "Corners are not the right distance from ",
                "each other (or not in the right order)");
    }
}
