import java.io.*;
import java.util.*;

public class Maarten {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new Maarten().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        String[] firstLine = reader.readLine().split(" ");
        int n = Integer.parseInt(firstLine[0]);
        int m = Integer.parseInt(firstLine[1]);

        Map<Integer, List<Integer>> edges = new HashMap<>();
        for (int i = 0; i < m; i++) {
            String[] line = reader.readLine().split(" ");
            int x = Integer.parseInt(line[0]);
            int y = Integer.parseInt(line[1]);
            edges.putIfAbsent(x, new ArrayList<>());
            edges.putIfAbsent(y, new ArrayList<>());
            edges.get(x).add(y);
            edges.get(y).add(x);
        }

        boolean[] visited = new boolean[n + 1];
        visited[1] = true;
        List<Integer> queue, next_queue = new ArrayList<>();
        next_queue.add(1);

        Map<Integer, List<Integer>> down = new HashMap<>();
        for (int i = 1; i <= n; i++) down.put(i, new ArrayList<>());
        int[] up = new int[n + 1];

        // Create a spanning tree in `down` and `up`
        while (!next_queue.isEmpty()) {
            queue = next_queue;
            next_queue = new ArrayList<>();
            for (int a : queue) {
                for (int b : edges.get(a)) {
                    if (!visited[b]) {
                        down.get(a).add(b);
                        up[b] = a;
                        visited[b] = true;
                        next_queue.add(b);
                    }
                }
            }
        }

        visited = new boolean[n + 1];
        visited[1] = true;
        int curr = 1, dist = 0;
        StringBuilder res = new StringBuilder();
        res.append(1);
        while (curr != 0) {
            if (!visited[curr] && (dist == 3 || down.get(curr).isEmpty())) {
                res.append(' ').append(curr);
                visited[curr] = true;
                dist = 0;
            }
            curr = down.get(curr).isEmpty() ? up[curr] : down.get(curr).remove(down.get(curr).size() - 1);
            dist += 1;
        }

        System.out.println(res);
    }
}
